%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 1 - Section 1:  Examining Polynomials
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

clc;
clear all;
close all;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 1: Figure Shown on Page 21

x  = 0:.1:4; u = x;
Quadratic =          x.^2 -  4*x + 3;
Cubic     = x.^3 - 6*x.^2 + 11*x - 6;
Quadratic2=          x.^2 -  4*x + 8;

figure(1);
subplot(1,2,1);
plot(x, Quadratic, 'k', 'LineWidth',1); grid on; hold on; title('Quadratic Polynomial');
plot([ 1 3], [0 0], 'ko','LineWidth',1);
set(gca,'XGrid','on', 'LineWidth', 1)
axis([0 4 -2 2]);
subplot(1,2,2);
plot(x, Cubic, 'k', 'LineWidth',1); grid on; hold on; title('Cubic Polynomial');
%plot(x, Cubic-.005, 'k', 'LineWidth',1);
plot([1 2 3], [0 0 0], 'ko','LineWidth',1);
set(gca,'XGrid','on', 'LineWidth', 1)
axis([0 4 -2 2]); 

figure(2);
plot(x, Quadratic2, 'k','LineWidth',1); grid on; hold on; title('Quadratic Polynomial');
plot(x, Quadratic, 'k','LineWidth', 1);
plot([ 1 3], [0 0], 'ko', 'MarkerSize' ,8);
axis([0 4 -2 8]);
set(gca,'XTick', [0 1 2 3]);
set(gca,'YTick', [0 2 4 6]);




%% 2. Figures and code shown on pages 22 and 23

x = 0:.25:4; y = -3:.25:3;
[X,Y] = meshgrid(x,y);

Mag1 = zeros(size(X));  %% Magnitude for polynomial with real roots
Mag2 = zeros(size(X));  %% Matnitude for polynomial with complex roots

for c1 = 1:size(X,1)
    for c2 = 1:size(X,2)
        Number      = X(c1,c2) + j*Y(c1,c2);
        Mag1(c1,c2) = abs(Number^2 - 4*Number + 3);
        Mag2(c1,c2) = abs(Number^2 - 4*Number + 8);
    end
end

figure(3);
h = mesh(X,Y,Mag1,'LineWidth', .5); hold on;
plot3(u, zeros(1,length(u)), Quadratic ,'k', 'LineWidth',3);
xlabel('real(x)'); ylabel('imag(x)'); zlabel('f(x)');
title('Magnitude Surface for a Quadratic Polynomial with Real Roots'); hold on;
axis([0 4 -3 3 0.0 15]);
colormap(gray); caxis([0 400]);
set(gca, 'XTick', [1 2 3]);
set(gca, 'XGrid','on', 'LineWidth', 1)
set(gca, 'YGrid','on', 'LineWidth', 1)
set(gca, 'ZGrid','on', 'LineWidth', 1)
%set(h,'FaceAlpha',.5);

%figure(15);
%h = mesh(X,Y,Mag1); hold on;
%plot3(u, zeros(1,length(u)), Quadratic ,'k', 'LineWidth' ,3);
%xlabel('real(x)'); ylabel('imag(x)'); zlabel('f(x)');
%title('Magnitude Surface for a Quadratic Polynomial with Real Roots'); hold on;
%axis([0 4 -3 3 0.0 15]);
%colormap(gray); caxis([0 400]);
%set(gca, 'XTick', [1 2 3]);
%set(h,'FaceAlpha',.5);



figure(4);
h1 = mesh(X,Y,Mag2, 'LineWidth', .75); hold on;
plot3(u, zeros(1,length(u)), Quadratic2 +.05 ,'k', 'LineWidth' ,3);
xlabel('real(x)'); ylabel('imag(x)'); zlabel('f(x)');
title('Magnitude Surface for a Quadratic Polynomial with Complex Roots'); hold on;
axis([0 4 -3 3 0.0 12]);
colormap(gray); caxis([0 400]);
set(gca, 'XTick', [1 2 3]);
set(gca, 'XGrid','on', 'LineWidth', 1.0)
set(gca, 'YGrid','on', 'LineWidth', 1.0)
set(gca, 'ZGrid','on', 'LineWidth', 1.0)
%set(h1,'FaceAlpha',.5);




%% Figure shown on page 26

f = 1; %Hz
t = 0:.05:3; %Seconds

Real = cos(2*pi*f*t);
Imag = sin(2*pi*f*t);

figure(5);
plot(t, Real, 'k', 'LineWidth' ,1); hold on; 
plot(t, Imag, 'k--','LineWidth' ,2); title('Real and Imaginary Parts of Complex Sinusoid');
xlabel('Time (seconds)'); 
legend('real(ComplexSinusoid)','imag(ComplexSinusoid)');