%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 1 - Section 2:  Linear Algebra
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


%% Defining the Problem  (Page 40)
 
P1 = [1,2]; P2 = [2,2]; P3 = [3,3]; P4 = [4,1];
X  = [P1(1,1); P2(1,1); P3(1,1); P4(1,1)];  %% Column Vector X
Y  = [P1(1,2); P2(1,2); P3(1,2); P4(1,2)];  %% Column Vector Y
 
%% Solving the Problem
 
F  = [ones(4,1) X X.^2 X.^3];
A  = inv(F)*Y
 
%% Plotting the Cubic Polynomial
 
x  = (0:.01:4.5)';
y  = [ones(length(x),1) x x.^2 x.^3]*A;
 
figure(1);
plot(x, y, 'k'); grid on; hold on; title('Cubic Polynomial');
plot(X, Y, 'ko'); xlabel('X'); ylabel('Y');
