%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 1 - Section 2:  Linear Algebra (PDF Graphs)
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


clc;
clear all;
close all;

%% Unpublished Code
%% 1. Plotting Gaussian PDF (Pages 46-49)

x = -8:.05:8;
m = 0;
s = 1;
y = (1/(s*sqrt(2*pi)))*exp( (-(x-m).^2)/(2*s^2));

figure(1);
plot(x,y,'k', 'LineWidth',2); grid on; title('Gaussian PDF of Dart Game (Player 1)');
xlabel('Distance in Inches from Center Line (x)');
ylabel('Probability Density');
set(gca, 'YTick', [0 .4 .8]);
axis([-6 6 0 .4])
box off
xx = x;
yy = y;



%% 2. Plotting Uniform PDF

x= -pi:.01:pi;
Level = 1/(2*pi)*ones(1,length(x));

figure(2);

plot([-pi x pi],[0 Level 0],'k', 'LineWidth',1.25); 
title('Uniform PDF of the Angle of Impact'); xlabel('Angle in radians');
ylabel('Probability Density');
set(gca, 'XTick', [-4  -2  0  2  4]);
set(gca, 'YTick', [0  .1 .2]);
axis([ -4 4 0 0.2]);
box off



%% 3. Plotting Rayleigh PDF

x = 0:.02:8;
a = 2;
y = (x*(1/(a*a)).*exp(-(1/(a*a))*(x.*x)));

a = 3;
y2 = (x*(1/(a*a)).*exp(-(1/(a*a))*(x.*x)));

figure(3);
plot(x,y,'k', 'LineWidth',2);  hold on;
plot(x,y2,'k--', 'LineWidth',2);title('Raleigh PDF'); xlabel('Distance');
ylabel('Probability Density'); legend('Alpha = 2','Alpha = 3');
axis([0 8 0 .25])
box off

D = randn(1,100000);
CCDF = [];
for i = 6:-.1: -6
    Sum = 0;
    for a = 1:100000
        if(D(1,a) >= i); Sum = Sum + 1; end;
    end
    CCDF = [CCDF Sum];
end

CDF = [];
for i = -6:.1: 6
    Sum = 0;
    for a = 1:100000
        if(D(1,a) <= i); Sum = Sum + 1; end;
    end
    CDF = [CDF Sum];
end


%% 4. Plotting Gaussian PDF, CDF, CCDF

figure(4);
subplot(2,2,[1 2]);
plot(xx, yy, 'k','LineWidth',1); title('Gaussian PDF ');
ylabel('Probability Density'); axis([-7 7 0 .45]);grid on;
set(gca, 'XTick', [ -6 -3 0 3 6]);
set(gca, 'YTick', [0 .2 .4]);      xlabel('x');

subplot(2,2,4);
plot(6:-.1: -6, CDF/100000,'k','LineWidth',1); grid on; axis([-7 7 0 1.005]);
set(gca, 'YTick', [0 .5 1]);
set(gca, 'XTick', [ -6 -3 0 3 6]); title('CCDF of Gaussian Random Variable');
ylabel(' ');     xlabel('x');

subplot(2,2,3);
plot(-6:.1: 6, CDF/100000,'k','LineWidth',1); grid on; axis([-7 7 0 1.005]);
set(gca, 'YTick', [0 .5 1]);
set(gca, 'XTick', [ -6 -3 0 3 6]); title('CDF of Gaussian Random Variable');
ylabel(' ');     xlabel('x');




