%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 1 - Section 3:  Linear Algebra
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


%% Example from pages 52-54

x = randn(1, 1000000);       %% Return gaussian distributed random numbers
y = randn(1, 1000000);       %% with variance = 1

Sequence1 = x + j*y;         %% Zero-mean ,random complex number sequence
Sequence2 = x*sqrt(2) + .6;  %% Random, real sequence with variance = 2
                             %% and mean = 0.6

%% Sequence 1
N1           = length(Sequence1);
Mean1        = (1/N1)*sum(Sequence1);
TotalPower1  = (1/N1)*sum(Sequence1.*conj(Sequence1));
RMS1         = sqrt(TotalPower1);
Var1         = (1/N1)*sum((Sequence1-Mean1).*conj(Sequence1-Mean1));
STD1         = sqrt(Var1);


%% Sequence 2
N2           = length(Sequence2);
Mean2        = (1/N2)*sum(Sequence2);
TotalPower2  = (1/N2)*sum(Sequence2.*conj(Sequence2));
RMS2         = sqrt(TotalPower2);
Var2         = (1/N2 )*sum((Sequence2-Mean2).*conj(Sequence2-Mean2));
STD2         = sqrt(Var2);


%% Plotting the PDF / Histograms

W  = 0.1;                     %% Width of histogram bin
x  = -4:W:4;
n1 = hist(real(Sequence1),x); %% Histogram --> Yield Gaussian Distribution
n2 = hist(abs(Sequence1) ,x); %% Histogram --> Yield Raleigh  Distribution

PDF1 = (n1/length(Sequence1))*(1/W);
PDF2 = (n2/length(Sequence1))*(1/W);

figure(1);
subplot(1,2,1);
plot(x, PDF1, 'k', 'LineWidth',2); title('PDF of real(Sequence1)');
xlabel('Displacement from 0'); ylabel('Probability Density'); axis([-4 4 0 0.5]); box off;
subplot(1,2,2);
plot(x, PDF2, 'k', 'LineWidth',2); title('PDF of Mag(Sequence1)');
xlabel('Displacement from 0'); ylabel('Probability Density'); axis([0 4 0 .8]); box off;
