%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 1 - Section 4: Random Processes
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 66 and 70)


Matrix = rand(1000,6);   %% Creates a matrix of 1000 rows and 6 columns
                         %% featuring random values between 0 and 1
Ensemble = 2*round(Matrix) - 1;  %% limiting the values to +/- 1
           
Ensemble_X = Ensemble(:, 2:6);  %% We will pick just 5 of the six columns

% Computing the auto-correlation function by comparing random variables 
% X2 to X0, X1, X2, X3 and X4

r_x20 = mean(Ensemble_X(:, 2 + 1) .* conj( Ensemble_X(:, 0 + 1)) );
r_x21 = mean(Ensemble_X(:, 2 + 1) .* conj( Ensemble_X(:, 1 + 1)) );
r_x22 = mean(Ensemble_X(:, 2 + 1) .* conj( Ensemble_X(:, 2 + 1)) );
r_x23 = mean(Ensemble_X(:, 2 + 1) .* conj( Ensemble_X(:, 3 + 1)) );
r_x24 = mean(Ensemble_X(:, 2 + 1) .* conj( Ensemble_X(:, 4 + 1)) );

[r_x20 r_x21 r_x22 r_x23 r_x24]


% We now apply the effect of the LTI system and define the Y ensemble

Ensemble_Y = Ensemble(:, 2:6) - 0.5*Ensemble(:, 1:5);

% Let's now compute the cross-correlation function by comparing random variables 
% X2 to Y0, Y1, Y2, Y3 and Y4

r_xy20 = mean(Ensemble_X(:, 2 + 1) .* conj( Ensemble_Y(:, 0 + 1)) );
r_xy21 = mean(Ensemble_X(:, 2 + 1) .* conj( Ensemble_Y(:, 1 + 1)) );
r_xy22 = mean(Ensemble_X(:, 2 + 1) .* conj( Ensemble_Y(:, 2 + 1)) );
r_xy23 = mean(Ensemble_X(:, 2 + 1) .* conj( Ensemble_Y(:, 3 + 1)) );
r_xy24 = mean(Ensemble_X(:, 2 + 1) .* conj( Ensemble_Y(:, 4 + 1)) );

[r_xy20 r_xy21 r_xy22 r_xy23 r_xy24]


r_y20 = mean(Ensemble_Y(:, 2 + 1) .* conj( Ensemble_Y(:, 0 + 1)) );
r_y21 = mean(Ensemble_Y(:, 2 + 1) .* conj( Ensemble_Y(:, 1 + 1)) );
r_y22 = mean(Ensemble_Y(:, 2 + 1) .* conj( Ensemble_Y(:, 2 + 1)) );
r_y23 = mean(Ensemble_Y(:, 2 + 1) .* conj( Ensemble_Y(:, 3 + 1)) );
r_y24 = mean(Ensemble_Y(:, 2 + 1) .* conj( Ensemble_Y(:, 4 + 1)) );

[r_y20 r_y21 r_y22 r_y23 r_y24]

%% Computing auto-correlation and cross correlation matrices

RX  = zeros(5,5);
RXY = zeros(5,5);

for a = 1:5
    for b = 1:5
        RX(a,b)  = mean(Ensemble_X(:,a) .* conj(Ensemble_X(:,b)));
        RXY(a,b) = mean(Ensemble_X(:,a) .* conj(Ensemble_Y(:,b)));
    end
end

RX
RXY



