%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 1 - Section 5:  
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 72)

%% Using the Fixed Point Toolbox
 
U1208 = quantizer('ufixed','nearest','saturate', [12 08]);
S1208 = quantizer( 'fixed',  'ceil', 'saturate',  [12 08]);
 
Q_PI     = quantize(U1208, pi);     %% Quantizing the value of PI
Q_PI_Dec = num2int(U1208, Q_PI);    %% Produces Value as Integer
Q_PI_Hex = num2hex(U1208, Q_PI);    %% Produces Value as Hexadecimal String
 
%% Quantizing and Rounding without the Fixed Point toolbox
 
PI_RoundX08 = (round(pi*256)/256); %% Rounding to the nearest 1/256
PI_FloorX08 = (floor(-pi*256)/256);%% Rounding down to lower 1/256
PI_CeilX08  = (ceil(-pi*256)/256); %% Rounding up to higher 1/256