%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 1 - Section 5: A Crash Course in MatLab  
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


clc;          % clear the command window
clear all;    % initialize or clear all previously used variable
close all;    % close all figure that are still open from the last run

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 76-79)

% Declaring Vectors and Matrices
R  = [1 2 3];        % Row vector or 1x3 matrix called R  
C  = [1;2;3];        % Column vector or 3x1 matrix called C
M  = [1 2 3; 4 5 6]; % 2x3 matrix M
M1 = zeros(2,3);     % 2x3 matrix of all zeros
M2 = ones(3,3);      % 3x3 square matrix of all 1s

Random2 = rand(2,5); % 2x5 matrix of random numbers between 0 and 1.0

% Extracting information from matrices
Value1 = M(1,3);    % Selects single element in row 1 and column 3 
Value2 = M(1,:);    % Value2 is equal to row one of matrix M
Value3 = M(:,2);    % Value3 is equal to column 2 of matrix M

SizeM  = size(M);   % the function size() returns the dimension of a
                    % matrix --> size(M) = [2 3]
N      = length(M); % returns the larger of the two matrix dimensions
                    % length(M) = 3

% Arithmatic of Matrices
A  = [1 2 1+j*2];   % Row vector or 1x3 matrix called A  
B1 = R*A';          % B1 = 8 - j6  (Transpose with conjugation)
B2 = R*A.';         % B2 = 8 + j6  (Transpose without conjugation)

B3 = R.*A;          % Point-by-point multiplication - yields 1x3 matrix
D1 = 1./R;          % Point-by-point reciprocal
D2 = R./A;          % Point-by-point division
Ex = R.^2;          % Squares each element individually - Ex = 1x3 matrix

% Displaying text
display(A);
display(['A is equal to [' num2str(A) ']']);

% Declaring vectors as ranges
n      = 0:1:7;             % Declares a row vector = [0 1 2 3 4 5 6 7]
Cosine = cos(2*pi*0.1*n);   % creates row vector of cosine values
Exp    = exp(j*2*pi*0.1*n); % creates complex sinusoid as a row vector

% Plotting
figure(1);
plot(n, real(Exp), 'k-x', 'LineWidth', 1); hold on;    % k-black;solid line;marker'x'
plot(n, imag(Exp), 'k:o', 'LineWidth', 1); grid on;    % k-black;dotted line;marker 'o'
title('Complex Sinusoid'); legend('real(Exp)','imag(Exp)');
xlabel('Discrete Time - n');

figure(2);
plot(n, real(Exp), 'k-x', 'LineWidth', 1.25); hold on;    % k-black;solid line;marker'x'
plot(n, imag(Exp), 'k--o', 'LineWidth', 1.25); grid on;    % k-black;dotted line;marker 'o'
title('Complex Sinusoid'); legend('real(Exp)','imag(Exp)');
xlabel('Discrete Time - n');
set(gca,'XGrid','on', 'LineWidth', 1.25)

figure(3);
plot(n, real(Exp), 'k-x', 'LineWidth', 2); hold on;    % k-black;solid line;marker'x'
plot(n, imag(Exp), 'k:o', 'LineWidth', 2); grid on;    % k-black;dotted line;marker 'o'
title('Complex Sinusoid'); legend('real(Exp)','imag(Exp)');
xlabel('Discrete Time - n');
set(gca,'XGrid','on', 'LineWidth', 2)
