%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 1 - Section 5:  QuantizeIt Function
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 72 - 73)

function [Output Overflow] = QuantizeIt(Input, TotalBits, FractionalBits, Flag)


Overflow = 0;
IntegerBits = TotalBits - FractionalBits;   %% Number of integer bits
FM = 2^FractionalBits;                      %% Fractional Multiplier
InputSign = Input./abs(Input+1e-40);        %% We need to figure out the
                                            %% sign here, since we will
                                            %% be taking the absolute value
                                            %% soon and the sign is lost

%%  Let's prepare for the quantization process

Input           = abs(Input);
IntegerInput    = floor(Input);
FractionalInput = InputSign.*(Input - IntegerInput);

switch(lower(Flag))
    case 'nearest'
        QuantizedFractionalOutput = (1/FM)*round(FractionalInput*FM);
    case 'ceil'
        QuantizedFractionalOutput = (1/FM)*ceil(FractionalInput*FM);
    case 'floor'
        QuantizedFractionalOutput = (1/FM)*floor(FractionalInput*FM);
end
   
QuantizedFractionalOutput = InputSign.*QuantizedFractionalOutput;
Output = InputSign*(IntegerInput + QuantizedFractionalOutput);

%%  Saturate the result

MaxPositiveValue = 2^(IntegerBits-1) - 1/FM;
MaxNegativeValue = -2^(IntegerBits-1);

if(Output > MaxPositiveValue)
    Overflow = 1;
    Output = MaxPositiveValue;
end

if(Output < MaxNegativeValue)
    Overflow = 1;
    Output(r,c) = MaxNegativeValue;
end
    

