%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 2 - Section 1:  Convolution
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Calculating convolution formulation 1  (Page 88)
x  = [2 2 3 4 2 2 4];    %% Our input Sequence x[n]
h  = [3 3 2];            %% Coefficients of our system h[n]
y  = zeros(1,length(x)); %% Output y[n]

DelayLine = zeros(1,3);

for n = 1:length(x)
    DelayLine(1,2:3) = DelayLine(1,1:2); %% Increment the pipe
    DelayLine(1,1)   = x(1,n);
    y(1,n)     = DelayLine*h.';
end
display(['Output y[n]: [ ' num2str(y) ' ]']);


%% Calculating convolution formulation 1 in Matrix Form 
X  = [2; 2; 3; 4; 2; 2; 4];    %% Input Sequence as column vector
h  = [3 3 2];                  %% Coefficients of our system h[n]
M = length(X);                 %% M = 7  -> Length of input/output sequence
N = length(h);                 %% N = 3  -> Length of the impulse response 

H = toeplitz([h zeros(1, M - N)], [h(1,1) zeros(1, M-1)] );
Y = H*X;
display(Y);








%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Convolution Example using formulation 2 (traditional formula)  (Page 90)

x  = [2 2 3 4 2 2 4];    %% Our input sequence x[n]
h  = [3 3 2];            %% Coefficients of our system h[n]
y  = zeros(1,length(x)); %% Output y[n]
 
M = length(x);           %% M = 7  -> Length of input/output sequence
N = length(h);           %% N = 3  -> Length of the impulse response 
 
H = toeplitz([h zeros(1, M - N)], [h(1,1) zeros(1, M-1)] )
y = H*x.';


