%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 2 - Section 2:  Correlation
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 93)

n = 0:59;
y = cos(2*pi*0.1*n);                           %% Analysis waveform
x = 2*cos(2*pi*0.1*n) + 1*cos(2*pi*0.2*n) ...  %% Composite waveform
  + 4*cos(2*pi*0.3*n);

Corr1 = mean(x.*conj(y))                        %% Correlation result
Corr2 = mean(x.*conj(cos(2*pi*0.2*n)))
Corr3 = mean(x.*conj(cos(2*pi*0.3*n)))
Corr4 = mean(x.*conj(sin(2*pi*0.1*n)))
Corr5 = mean(x.*conj(cos(2*pi*0.4*n)))


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 94)

n  = 0:59;
y1 = cos(2*pi*0.1*n);                        %% Analysis waveform 1
y2 = sin(2*pi*0.1*n);                        %% Analysis waveform 2       
x  = 2*cos(2*pi*0.1*n+pi/4) + ...            %% Composite waveform
     1*cos(2*pi*0.2*n) + 4*cos(2*pi*0.3*n);

R1 = mean(x.*conj(y1));                      %% Correlation result 1
R2 = mean(x.*conj(y2));                      %% Correlation result 2

M = 2*R1 + j*2*R2;
[abs(M) -angle(M)]


