%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 2 - Section 2:  Correlation (Barker Sequence)
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 95)

SNR        = 10;                            %% dB 
B          = [1 1 1 -1 -1 -1 1 -1 -1 1 -1]; %% Barker code of length = 11
PowerOfB   = (1/length(B))*mean(B*B');      %% Mean square of B --> 
						                    %% Average power
SNRLinear  = 10^(SNR/10);
NoisePower = PowerOfB/SNRLinear;
AWGNoise   = sqrt(NoisePower)*randn(1,200); %% Creating additive 
						                    %% white Gaussian noise                                           
RXSignal   = AWGNoise + [zeros(1,50) B zeros(1,139)];



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 96)

ShiftRegister = zeros(1,11);
C             = fliplr(B);   %% Shift Register tap values

for i= 1:200
    ShiftRegister(1,2:11) = ShiftRegister(1,1:10); %% Shifting Operation
    ShiftRegister(1,1)    = RXSignal(1,i);
    Output(1,i)           = ShiftRegister*C';
end

figure(1);
stem(Output,'k', 'LineWidth', 1); grid on; 
title('Output of Sliding Correlator'); xlabel('n'); axis([0 150 -5 15])


