%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 2 - Section 2:  Correlation (Walsh Codes)
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

clc;
clear all;
close all;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 100)

W = [1  1  1  1  1  1  1  1;   %% Defining the Walsh code family
     1 -1  1 -1  1 -1  1 -1;
     1  1 -1 -1  1  1 -1 -1;
     1 -1 -1  1  1 -1 -1  1;
     1  1  1  1 -1 -1 -1 -1;
     1 -1  1 -1 -1  1 -1  1;
     1  1 -1 -1 -1 -1  1  1;
     1 -1 -1  1 -1  1  1 -1];
 
User1DataW0 = [ 1*W(1,:) -1*W(1,:)  1*W(1,:)];
User2DataW1 = [-1*W(2,:) -1*W(2,:)  1*W(2,:)];
User3DataW2 = [-1*W(3,:)  1*W(3,:) -1*W(3,:)];
Composite = User1DataW0 + User2DataW1 + User3DataW2;

figure(10);
subplot(2,3,1);
stem(User1DataW0,'k', 'LineWidth', .9); grid on; title('Spread User1Data'); axis([1 25 -1.2 1.2]);
set(gca, 'XGrid','on', 'LineWidth', .9)
set(gca, 'YGrid','on', 'LineWidth', .9)
set(gca, 'ZGrid','on', 'LineWidth', .9)
set(gca, 'XTick', [10 20]);
subplot(2,3,2);
stem(User2DataW1,'k', 'LineWidth', .9); grid on; title('Spread User2Data'); axis([1 25 -1.2 1.2]);
set(gca, 'XGrid','on', 'LineWidth', .9)
set(gca, 'YGrid','on', 'LineWidth', .9)
set(gca, 'ZGrid','on', 'LineWidth', .9)
set(gca, 'XTick', [10 20]);
subplot(2,3,3);
stem(User3DataW2,'k', 'LineWidth', .9); grid on; title('Spread User3Data'); axis([1 25 -1.2 1.2]);
set(gca, 'XGrid','on', 'LineWidth', .9)
set(gca, 'YGrid','on', 'LineWidth', .9)
set(gca, 'ZGrid','on', 'LineWidth', .9)
set(gca, 'XTick', [10 20]);
subplot(2,3, [4 5 6]);
stem(Composite,'k', 'LineWidth', .9); grid on; title('Composite Signal'); axis([1 25 -3.5 3.5]);
set(gca, 'XGrid','on', 'LineWidth', .9)
set(gca, 'YGrid','on', 'LineWidth', .9)
set(gca, 'ZGrid','on', 'LineWidth', .9)
set(gca, 'YTick', [-3 -2 -1 0 1 2 3]);


figure(11);
subplot(2,3,1);
stem(User1DataW0,'k', 'LineWidth', 1.00); grid on; title('Spread User1Data'); axis([1 25 -1.2 1.2]);
set(gca, 'XGrid','on', 'LineWidth', 1.00)
set(gca, 'YGrid','on', 'LineWidth', 1.00)
set(gca, 'ZGrid','on', 'LineWidth', 1.00)
set(gca, 'XTick', [10 20]);
subplot(2,3,2);
stem(User2DataW1,'k', 'LineWidth', 1.0); grid on; title('Spread User2Data'); axis([1 25 -1.2 1.2]);
set(gca, 'XGrid','on', 'LineWidth', 1.0)
set(gca, 'YGrid','on', 'LineWidth', 1.0)
set(gca, 'ZGrid','on', 'LineWidth', 1.0)
set(gca, 'XTick', [10 20]);
subplot(2,3,3);
stem(User3DataW2,'k', 'LineWidth', 1.0); grid on; title('Spread User3Data'); axis([1 25 -1.2 1.2]);
set(gca, 'XGrid','on', 'LineWidth', 1.0)
set(gca, 'YGrid','on', 'LineWidth', 1.0)
set(gca, 'ZGrid','on', 'LineWidth', 1.0)
set(gca, 'XTick', [10 20]);
subplot(2,3, [4 5 6]);
stem(Composite,'k', 'LineWidth',1.2); grid on; title('Composite Signal'); axis([1 25 -3.5 3.5]);
set(gca, 'XGrid','on', 'LineWidth', 1.0)
set(gca, 'YGrid','on', 'LineWidth', 1.0)
set(gca, 'ZGrid','on', 'LineWidth', 1.0)
set(gca, 'YTick', [-3 -2 -1 0 1 2 3]);
figure(1);
stem(Composite,'k'); grid on; title('Composite CDMA Stream');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 101)

%% Despreading Step 1
T1 = Composite .* [W(1,:) W(1,:)  W(1,:)]; 
T2 = Composite .* [W(2,:) W(2,:)  W(2,:)];
T3 = Composite .* [W(3,:) W(3,:)  W(3,:)];

%% Despreading Step 2
User1Out = (1/8)*[sum(T1(1,1:8)) sum(T1(1,9:16)) sum(T1(1,17:24))]
User2Out = (1/8)*[sum(T2(1,1:8)) sum(T2(1,9:16)) sum(T2(1,17:24))]
User3Out = (1/8)*[sum(T3(1,1:8)) sum(T3(1,9:16)) sum(T3(1,17:24))]