%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 2 - Section 3:  Discrete Time Fourier Transform
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 119)

N             = 20;                    %% Sequence Length
n             = 0:1:N-1;               %% discrete time index 
TestSequence1 = cos(2*pi*0.1*n);      
TestSequence2 = exp(j*2*pi*0.315*n);    
TestSequence3 = exp(j*2*pi*0.1*n) + 0.02*exp(j*2*pi*(-0.25)*n);

FResolution = 0.001;                  %% Hertz 
Frequencies = -0.5:FResolution:0.5;  %% Test Frequencies

DTFT_Out1   = zeros(1,length(Frequencies));
DTFT_Out2   = zeros(1,length(Frequencies));
DTFT_Out3   = zeros(1,length(Frequencies));
    
for i = 1:length(Frequencies)
   f             = Frequencies(1,i); %% Current Analysis Frequency
   AnalysisTone  = exp(j*2*pi*n*f);
   DTFT_Out1(1,i)= (1/N)*TestSequence1*AnalysisTone'; %% Summation
   DTFT_Out2(1,i)= (1/N)*TestSequence2*AnalysisTone';
   DTFT_Out3(1,i)= (1/N)*TestSequence3*AnalysisTone';
end
    
figure(1);
subplot(2,2,1);
plot(Frequencies, abs(DTFT_Out1), 'k', 'LineWidth', 1); title('Magnitude Response of TestSequence1');
xlabel('Normalized Frequency'); 
set(gca,'XGrid','on', 'LineWidth', 1); grid on; axis([-0.5 0.5 0 1]); 

subplot(2,2,2);
plot(Frequencies, abs(DTFT_Out2), 'k', 'LineWidth', 1); title('Magnitude Response of TestSequence2');
xlabel('Normalized Frequency'); 
set(gca,'XGrid','on', 'LineWidth', 1); grid on; axis([-0.5 0.5 0 1]); 

subplot(2,2,3:4);
plot(Frequencies, abs(DTFT_Out3), 'k', 'LineWidth', 1); title('Magnitude Response of TestSequence3');
xlabel('Normalized Frequency'); 
set(gca,'XGrid','on', 'LineWidth', 1); grid on; axis([-0.5 0.5 0 1]); 

figure(2);
subplot(2,1,1);
plot(Frequencies, 20*log10( abs(DTFT_Out3) ), 'k', 'LineWidth', 0.9); title('Magnitude Response of TestSequence3 -- N = 20');
xlabel('Normalized Frequency'); axis([-0.5 0.5 -60 0]); grid on; ylabel('dB')
set(gca,'XGrid','on', 'LineWidth', 0.9);
  
N             = 100;                    %% Sequence Length
n             = 0:1:N-1;               %% discrete time index 
TestSequence3 = exp(j*2*pi*0.1*n) + 0.01*exp(j*2*pi*(-0.25)*n);

FResolution = 0.001;                  %% Hertz 
Frequencies = -0.5:FResolution:0.5;  %% Test Frequencies

DTFT_Out4   = zeros(1,length(Frequencies));
    
for i = 1:length(Frequencies)
   f             = Frequencies(1,i); %% Current Analysis Frequency
   AnalysisTone  = exp(j*2*pi*n*f);
   DTFT_Out4(1,i)= (1/N)*TestSequence3*AnalysisTone';
end
    

subplot(2,1,2);
plot(Frequencies, 20*log10( abs(DTFT_Out4) ), 'k', 'LineWidth', 0.9);
title('Magnitude Response of TestSequence3 -- N = 100');
xlabel('Normalized Frequency'); axis([-0.5 0.5 -60 0]); grid on; ylabel('dB')
set(gca,'XGrid','on', 'LineWidth', 0.9);


