%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 2 - Section 3:  DTFT using the Hanning Window
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 120)

N           = 40;                      %% Sequence Length
n           = 0:1:N-1;

Rectangular = ones(1,N);                                  %% Rectangular Window
Hanning     = (40/20.5)*(0.5- 0.5*cos(2*pi*(n+1)/(N+1))); %% Hanning Window 

TestSequence= exp(j*2*pi*n*0.1) + 0.01*exp(-j*2*pi*n*0.25);
FResolution = 0.002;                   %% Hertz 
Frequencies = -0.5:FResolution:0.5;    %% Test Frequencies
DTFT_OutRect    = zeros(1,length(Frequencies));
DTFT_OutHann    = zeros(1,length(Frequencies));
    
for i = 1:length(Frequencies)          %% DTFT Calculation
   f            = Frequencies(1,i);    %% Current Analysis Frequency
   AnalysisTone = exp(j*2*pi*n*f);
   DTFT_OutRect(1,i)=(1/N)*(TestSequence.*Rectangular)*AnalysisTone';
   DTFT_OutHann(1,i)=(1/N)*(TestSequence.*Hanning)*AnalysisTone'; 
end
MagSpectrumRect = abs(DTFT_OutRect);
MagSpectrumHann = abs(DTFT_OutHann);

figure(1);
subplot(2,2,1);
plot(real(TestSequence.*Rectangular), 'k'); hold on; title('Test Sequence Rectangular Window');
plot(real(TestSequence.*Rectangular), 'ko', 'MarkerSize' , 4);
plot(imag(TestSequence.*Rectangular), 'k--'); axis([0 40 -1.1 1.1]); xlabel('Discrete Time n');
plot(imag(TestSequence.*Rectangular), 'ko', 'MarkerSize' , 4);

subplot(2,2,2);
plot(Frequencies, 20*log10(MagSpectrumRect), 'k'); axis([-.5 .5 -60 0]);
ylabel('dB'); xlabel('Normalized Frequency'); title('Magnitude Response (Rectangular Windowed)');


subplot(2,2,3);
plot(real(TestSequence.*Hanning), 'k'); hold on; title('Test Sequence Hanning Window');
plot(real(TestSequence.*Hanning), 'ko', 'MarkerSize' , 4);
plot(imag(TestSequence.*Hanning), 'k--'); axis([0 40 -2 2]); xlabel('Discrete Time n');
plot(imag(TestSequence.*Hanning), 'ko', 'MarkerSize' , 4);
subplot(2,2,4);
plot(Frequencies, 20*log10(MagSpectrumHann), 'k'); axis([-.5 .5 -60 0]);
ylabel('dB'); xlabel('Normalized Frequency'); title('Magnitude Response (Hanning Windowed)');