%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 2 - Section 3:  Radix-2 N=16 FFT
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 139)

Memory     = zeros(16, 5);
Length     = 16;
Order           = 1 + [0 8 4 12 2 10 6 14   1 9 5 13 3 11 7 15];
%% Input Sequence cos(2 pi Freq *n/SampleRate)
n              = 0:1:Length-1;
Freq           = .05;
Input          = cos(2*pi*Freq*n/1);
Memory(Order,1) = Input.'; 

figure(1);
plot(real(Input), 'k'); grid on; hold on;
plot(imag(Input), 'b'); title('Time Domain Input Signal');


for Section = 1:1:4
    N     = 2^Section;     %% Current section contains N-point DFT Modules
    Reps  = 16/N;          %% Number of N-point DFT Modules in current section
    I     = 2^(Section-1); %% Limit for index i
    
    Offset  = 1;
    for a = 0:Reps-1
        for i = 0:I-1
            Ini     = Memory( Offset + i      , Section);
            IniN_2  = Memory( Offset + i + N/2, Section);
            
            Wi      = exp(-j*2*pi*i/N);
            WiN_2   = exp(-j*2*pi*(i+N/2)/N);
            
            Memory( Offset + i      , Section + 1) = Ini + Wi    * IniN_2;
            Memory( Offset + i + N/2, Section + 1) = Ini + WiN_2 * IniN_2;
        end
    Offset = Offset + N;
    end
end
        
Out_Perfect = fft(Input);   %% Using native MatLab fft function

Out_Mine    = Memory(:,5);  %% FFT result as computed by function above

[Out_Perfect.' Memory(:,5)] %% Side by Side Comparison of the two
