%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 2 - Section 3:  Radix-4 N=16 FFT
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 144)

Memory     = zeros(16, 3);
Length     = 16;

%% Input Sequence cos(2 pi Freq *n/SampleRate)
n              = 0:1:Length-1;
Freq           = .05;
SampleRate     = 1;
N              = 16;
Input          = cos(2*pi*Freq*n/SampleRate);

figure(1);
plot(real(Input), 'k'); grid on; hold on;
plot(imag(Input), 'b'); title('Time Domain Input Signal');



Order           = 1 + [0 4 8 12 1 5 9 13   2 6 10 14 3 7 11 15];
Memory(Order,1) = Input.'; 

for Section = 1:1:2
    N     = 4^Section;     %% Current section contains N-point DFT Modules
    Reps  = 16/N;          %% Number of N-point DFT Modules in current section
    I     = 4^(Section-1); %% Limit for index i
    
    Offset  = 1;
    for a = 0:Reps-1
        for i = 0:I-1      %% Start of Radix-4 Butterfly
            Ini      = Memory( Offset + i        , Section);
            IniN_4   = Memory( Offset + i + N/4  , Section);
            IniN_2   = Memory( Offset + i + N/2  , Section);
            Ini3N_4  = Memory( Offset + i + 3*N/4, Section);
            
            Wi       = exp(-j*2*pi*i/N);
            WiN_4    = exp(-j*2*pi*(i+N/4)/N);
            WiN_2    = exp(-j*2*pi*(i+N/2)/N);
            Wi3N_4   = exp(-j*2*pi*(i+3*N/4)/N);
            
            W2i      = exp(-j*2*pi*2*i/N);
            W2iN_4   = exp(-j*2*pi*2*(i+N/4)/N);
            W2iN_2   = exp(-j*2*pi*2*(i+N/2)/N);
            W2i3N_4  = exp(-j*2*pi*2*(i+3*N/4)/N);
                            
            W3i      = exp(-j*2*pi*3*i/N);
            W3iN_4   = exp(-j*2*pi*3*(i+N/4)/N);
            W3iN_2   = exp(-j*2*pi*3*(i+N/2)/N);
            W3i3N_4  = exp(-j*2*pi*3*(i+3*N/4)/N);
            
            Memory( Offset + i        , Section + 1) = ...
                            Ini + Wi*IniN_4     + W2i*IniN_2     + W3i*Ini3N_4;
            Memory( Offset + i + N/4  , Section + 1) = ...
                            Ini + WiN_4*IniN_4  + W2iN_4*IniN_2  + W3iN_4 *Ini3N_4;
            Memory( Offset + i + N/2  , Section + 1) = ...
                            Ini + WiN_2*IniN_4  + W2iN_2*IniN_2  + W3iN_2 *Ini3N_4;
            Memory( Offset + i + 3*N/4, Section + 1) = ...
                            Ini + Wi3N_4*IniN_4 + W2i3N_4*IniN_2 + W3i3N_4*Ini3N_4;
        end                %% End of Radix-4 Butterfly
    Offset = Offset + N;
    end
end
Output      = Memory(:, 3).';

Out_Perfect = fft(Input);   %% Ideal Output as computed by MatLab fft function

Out_Mine    = Memory(:,3);  %% Our result

[Out_Perfect.' Memory(:,3)] %% The two compared
