%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 2 - Section 3:  Effect of Windowing
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Unpublished Code generating graphs on page 123

N = 13;
n = 0:N-1;

Hn = 0.50 - 0.50*cos(2*pi*(n + 1)/(N+1)); 
Hm = 0.54 - 0.46*cos(2*pi*(n + 1)/(N+1)) 
Re = ones(1,N);

Hn_Plot = [0 0 0 Hn 0 0 0];
Hm_Plot = [0 0 0 Hm 0 0 0];
Re_Plot = [0 0 0 Re 0 0 0];

Range = -3:N+2;

%% DTFT Calclation

TestSequence1 = Hn;    
TestSequence2 = Hm;
TestSequence3 = Re;

FResolution = 0.001;              %% Hertz 
Frequencies = 0:FResolution:0.5;  %% Test Frequencies

DTFT_Out1   = zeros(1,length(Frequencies));
DTFT_Out2   = zeros(1,length(Frequencies));
DTFT_Out3   = zeros(1,length(Frequencies));
    
for i = 1:length(Frequencies)
   f             = Frequencies(1,i);                  %% Current Analysis Frequency
   AnalysisTone  = exp(j*2*pi*n*f);
   DTFT_Out1(1,i)= (1/N)*TestSequence1*AnalysisTone'; %% Summation
   DTFT_Out2(1,i)= (1/N)*TestSequence2*AnalysisTone';
   DTFT_Out3(1,i)= (1/N)*TestSequence3*AnalysisTone';
end

Log_1 = 20*log10(abs(DTFT_Out1));
Log_2 = 20*log10(abs(DTFT_Out2));
Log_3 = 20*log10(abs(DTFT_Out3));


figure(2);
subplot(2,3,1);
stem(Range, Hn_Plot, 'k', 'LineWidth', .9); hold on; title('Hanning Window N = 13');
plot(Range, Hn_Plot, 'k--', 'LineWidth', .9); axis([-3 15 0 1]);
subplot(2,3,2);
stem(Range, Hm_Plot, 'k', 'LineWidth', .9); hold on; title('Hamming Window N = 13');
plot(Range, Hm_Plot, 'k--', 'LineWidth', .9); axis([-3 15 0 1]);
subplot(2,3,3);
stem(Range, Re_Plot, 'k', 'LineWidth', .9); hold on; title('Rectangular Window N = 13');
plot(Range, Re_Plot, 'k--', 'LineWidth', .9); axis([-3 15 0 1]);
subplot(2,3,4:6);
step = 50;
plot(Frequencies, Log_1 - max(Log_1), 'k', 'LineWidth', 2.5);  hold on;
plot(Frequencies(1:step:end), Log_2(1:step:end) - max(Log_2(1:step:end)), 'kd', 'LineWidth', .9);
plot(Frequencies(1:step:end), Log_3(1:step:end) - max(Log_3(1:step:end)), 'kx', 'LineWidth', .9);
legend('Hanning', 'Hamming', 'Rectangular');
%plot(Frequencies, Log_1 - max(Log_1), 'k'); 
plot(Frequencies, Log_2 - max(Log_2), 'k', 'LineWidth', .9);
plot(Frequencies, Log_3 - max(Log_3), 'k', 'LineWidth', .9); axis([0 0.5 -60 1.2]);
title('Magnitude Response of Different Windows');
xlabel('Normalized Frequency'); ylabel('dB');