%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 2 - Section 5:  Phase and Group Delay
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 161)

%% Define an impulse response
h       = [ 0 1 1 0];
h_norm  = (1/abs(sum(h)))*h;    %% Normalizing h[n]
N       = length(h_norm);
n       = 0:1:N-1;
Frequencies  = -0.5:.002:0.5;
DTFT_Output  = zeros(1,length(Frequencies));

for i=1:length(Frequencies)
    f                = Frequencies(1,i);
    AnalysisTone     = exp(j*2*pi*n*f);
    DTFT_Output(1,i) = h_norm*AnalysisTone';
end
MagnitudeResponse  = abs(DTFT_Output);
PhaseResponse      = unwrap(angle(DTFT_Output));

%PhaseDelay         = -PhaseResponse./(2*pi*Frequencies);

%% The Group Delay Calculation
GroupDelay         = zeros(1, length(Frequencies));
for i = 2:length(Frequencies)-1
    FrequencyDelta     = Frequencies(1, i+1) - Frequencies(1, i-1);
    PhaseResponseDelta = PhaseResponse(1,i+1) - PhaseResponse(1, i-1);
    GroupDelay(1,i)    = (-1/(2*pi))* PhaseResponseDelta/FrequencyDelta;
end
GroupDelay(1,1) = GroupDelay(1,2);
GroupDelay(1,length(Frequencies)) = GroupDelay(1,length(Frequencies)-1);
        
figure(2);
subplot(1,2,1);
plot(Frequencies, MagnitudeResponse, 'k', 'LineWidth', 1);    grid on; hold on; 
title('Magnitude Response for h=[0 1 1 0]'); xlabel('Normalized Frequency');



figure(1);
subplot(2,2,1);
plot(Frequencies, PhaseResponse, 'k', 'LineWidth', 1);      grid on; hold on;
title('Phase Response for h=[0 1 1 0]');     xlabel('Normalized Frequency');
subplot(2,2,3);
plot(Frequencies, GroupDelay, 'k', 'LineWidth', 1);           grid on; hold on; 
title('Group Delay for h=[0 1 1 0]');        xlabel('Normalized Frequency');
axis([-.5 .5 0 3]);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 161) repeated for h = [ 0 .5 1 0] rather than h = [ 0 1 1 0]

%% Define an impulse response
h       = [ 0 .5 1 0];
h_norm  = (1/abs(sum(h)))*h;    %% Normalizing h[n]
N       = length(h_norm);
n       = 0:1:N-1;
Frequencies  = -0.5:.002:0.5;
DTFT_Output  = zeros(1,length(Frequencies));

for i=1:length(Frequencies)
    f                = Frequencies(1,i);
    AnalysisTone     = exp(j*2*pi*n*f);
    DTFT_Output(1,i) = h_norm*AnalysisTone';
end
MagnitudeResponse  = abs(DTFT_Output);
PhaseResponse      = unwrap(angle(DTFT_Output));

%PhaseDelay         = -PhaseResponse./(2*pi*Frequencies);

%% The Group Delay Calculation
GroupDelay         = zeros(1, length(Frequencies));
for i = 2:length(Frequencies)-1
    FrequencyDelta     = Frequencies(1, i+1) - Frequencies(1, i-1);
    PhaseResponseDelta = PhaseResponse(1,i+1) - PhaseResponse(1, i-1);
    GroupDelay(1,i)    = (-1/(2*pi))* PhaseResponseDelta/FrequencyDelta;
end
GroupDelay(1,1) = GroupDelay(1,2);
GroupDelay(1,length(Frequencies)) = GroupDelay(1,length(Frequencies)-1);

figure(2);
subplot(1,2,2);
plot(Frequencies, MagnitudeResponse, 'k', 'LineWidth', 1);     grid on; hold on; 
title('Magnitude Response for h=[0 .5 1 0]'); xlabel('Normalized frequency');

figure(1);
subplot(2,2,2);
plot(Frequencies, PhaseResponse, 'k', 'LineWidth', 1);         grid on; hold on;
title('Phase Response for h=[0 .5 1 0]');     xlabel('Normalized frequency');
subplot(2,2,4);
plot(Frequencies, GroupDelay, 'k', 'LineWidth', 1);            grid on; hold on; 
title('Group Delay for h=[0 .5 1 0]');        xlabel('Normalized frequency');

%% Verification via matlab --- correct
[gd,f] = grpdelay([0 .5 1 0], 1, 100, 1);

%figure(3);
%plot(f, gd, 'k', 'LineWidth', 1);  grid on;
