%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 3 - Section 1:  FIR Filter Design 
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 179)

%% 1. Method one via IDFT

N = 17;                %% Number of FIR Filter Taps
H = [ .1 .1 .1 .1 .5 1 1 1 1 1 1 1 .5 .1 .1 .1 .1];

figure(1); subplot(2,1,1);
plot(-8:1:8, abs(H),'k-o', 'LineWidth', .9); grid on;
title('Magnitude Response of Desired Filter');
xlabel('Discrete Frequency Index m'); ylabel('Magnitude');
axis([-8.0 8.0 0 1.2]);
set(gca, 'XTick', [-8 -4 0 4 8]);
set(gca, 'LineWidth', 1.0);

n = -8:1:8; m = -8:1:8;
h = zeros(1,length(n));

for d=0:1:16             %% Take IDFT to find impulse response
    E = exp(j*2*pi*m*n(1,d+1)/N);
    h(1,d+1) = H*E.'/N; 
end

n2 = -8:.25:8;
h2 =  zeros(1,length(n2));

for d=0:1:length(n2)-1   %% Take Discrete Time FT to find 
                         %% the impulse response at a higher resolution
    E = exp(j*2*pi*m*n2(1,d+1)/N);
    h2(1,d+1) = H*E.'/N; 
end

subplot(2,1,2);
plot(n, real(h),'ko', 'LineWidth', .9); grid on; hold on;
plot(n2, real(h2),'k', 'LineWidth', .9); title('Real Part of Impulse Response ');
xlabel('Discrete Time Index n'); set(gca, 'XTick', [-8 -4 0 4 8]);set(gca, 'LineWidth', 1.0);
h.'


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 180)

%% 2. Method 2 via Matrix Calculations

N                   = 17; 
n                   = -8:1:8;
FrequencyResponse   = [.1 .1 .1 .1 .5 1 1 1 1 1 1 1 .5 .1 .1 .1 .1];
m                   = -8:1:8;

%% Building the H and F matrices
 
H = FrequencyResponse.';
F = zeros(length(FrequencyResponse), N);
for a=1:length(FrequencyResponse)
    for b = 1:N
        F(a,b) = exp(-j*2*pi*n(1,b)*m(1,a)/17);
    end
end
h = inv(F)*H;      %% Same Result with h = inv(F*F)*F*H

h