%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 3 - Section 1:  FIR Filter Design using LSE Technique Part2
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 183)

%% Conditions and Constraints

FrequencyResponse = [ .2 .1 .1 .1 .5 1 1 1 1 1 1 1 .5 .1 .1 .1 .1];
Weighting         = [ 100 100 100 100 1 1 1 1 1 1 1 1 1 1 1 1 1 ];
m                 = [-7.5 -7:1:8];  %% Does not have to be unit steps
FrequencyRange    = m/17;          %% 17 is the number of constraints

 
%% Defining the discrete time, n, of the impulse response 
 
N = 9;                         %% Tap Number of the target filter
if(mod(N,2) == 1)              %% Odd tap number
    n = -(N-1)/2:1:(N-1)/2;
else                           %% Even tap number
    n = -((N/2)-.5):1:(N/2)-.5;
end


%% Execute Least Squares Calculation
 
H = FrequencyResponse.';
F = zeros(length(FrequencyResponse), N);
for a=1:length(FrequencyResponse)
    for b = 1:N
        F(a,b) = exp(-j*2*pi*n(1,b)*m(1,a)/17);
    end
end

W = diag(Weighting);
h = inv(F'*W*F)*F'*W*H %% Impulse Response as column vector
 
%% Check Result using the DTFT
 
Frequencies = -0.5:.01:0.5;  %% Defining the analysis frequencies
DTFT_Out = zeros(1,length(Frequencies));
for i = 1:length(Frequencies)
    f             = Frequencies(1,i); %% Current Analysis Frequency
    AnalysisTone  = exp(j*2*pi*n*f);  %% Current Analysis Tone
    DTFT_Out(1,i) = h.'*AnalysisTone';         
end

figure(2);
stem(FrequencyRange, FrequencyResponse,'k', 'LineWidth', .9); hold on;
xlabel('Frequency');
plot(Frequencies, abs(DTFT_Out), 'k--', 'LineWidth', .9); legend('Constraints','DTFT'); 
title('Magnitude Response of FIR Filter');

figure(1);
subplot(2,1,1); stem(FrequencyRange*40e6, FrequencyResponse,'k'); hold on;
xlabel('Frequency');
plot(Frequencies*40e6, abs(DTFT_Out), 'k:'); legend('Constraints','DTFT'); 
title('Magnitude Response of FIR Filter');
subplot(2,1,2); stem(n, real(h), 'k');  hold on;
stem(n, imag(h), 'r');
title('Impulse Response of Optimal FIR Filter');
