%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 3 - Section 1:  Least Squares Error Surfaces
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

clc;
clear all;
close all;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 169)

P1 = [1 1 1];  P2 = [1 -1 .95];  P3 = [-1 -1 1]; P4 = [-1 1 1];
InterceptGuess = 1.0;   %% Or Chose 1.5
Slope1Range    = -1:.1:1;
Slope2Range    = -1:.1:1;

[Slope1,Slope2]   = meshgrid(Slope1Range, Slope2Range);
LSE               = zeros(size(Slope1));
AbsoluteError1    = zeros(size(Slope1));
S                 = size(Slope1);

for a = 1:S(1,1)
    for b = 1:S(1,2)
        S1   = Slope1(a,b);
        S2   = Slope2(a,b);
        e1   = P1(1,3) - (InterceptGuess + S1*P1(1,1) + S2*P1(1,2));
        e2   = P2(1,3) - (InterceptGuess + S1*P2(1,1) + S2*P2(1,2));
        e3   = P3(1,3) - (InterceptGuess + S1*P3(1,1) + S2*P3(1,2));
        e4   = P4(1,3) - (InterceptGuess + S1*P4(1,1) + S2*P4(1,2));
        LSE(a,b) = e1*e1 + e2*e2 + e3*e3 + e4*e4;
        AbsoluteError1(a,b)= abs(e1) + abs(e2) + abs(e3) + abs(e4);
    end
end

figure(1);
subplot(1,2,1);
mesh(Slope1, Slope2, LSE); 
xlabel('X Slope'); ylabel('Y Slope'); zlabel('SE');
title('Square Error Surface'); axis([-1 1 -1 1 0 10]);
colormap('gray'); caxis([-5 20000]); set(gca, 'LineWidth', 1.0);
alpha(1);
        
subplot(1,2,2);
mesh(Slope1, Slope2, AbsoluteError1); 
xlabel('X Slope'); ylabel('Y Slope'); zlabel('Absolute Error');
axis([-1 1 -1 1 0 8]); title('Absolute Error Surface');
colormap('gray');       caxis([-5 2000]); set(gca, 'LineWidth', 1.0);


