%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 3 - Section 1:  Polynomial Regression based on WLSE Technique
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 177)

%% Based on LSE
InputPower  = [-10 -5    0   5  10    15  20  25];
OutputPower = [ 0   5.5 10  14  18.5  21  21  21];
X           = InputPower';
Z           = OutputPower';      %% Output Power as a column vector

F       =  [ones(size(Z))  X X.^2 X.^3 X.^4]; %% Defining Matrix F
A       = inv(F'*F)*F'*Z;                    %% Here we solve for A


%% Based on WLSE
Weight  = [ 1 1 1 1 1 100 100 100]; %% Add this line to previous code
W       = diag(Weight);		        %% Add this line to previous code
AW      = inv(F'*W*F)*F'*W*Z;       %% Change from A = inv(F'*F)*F'*Z       

InRange  = -10:.1:25;
CurveFit = A(1,1)   + A(2,1)*InRange  + A(3,1)*InRange.^2  ...
                    + A(4,1)*InRange.^3   + A(5,1)*InRange.^4;
                
CurveFitW= AW(1,1)  + AW(2,1)*InRange  + AW(3,1)*InRange.^2  ...
                    + AW(4,1)*InRange.^3   + AW(5,1)*InRange.^4;

figure(1);
plot(InputPower, OutputPower, 'ko', 'LineWidth', .9); hold on;
plot(InRange, CurveFitW, 'k', 'LineWidth',.9);
title('Curve Fit Based on the Method of Least Squares');
plot(InRange, CurveFit, 'k--', 'LineWidth', .9);
legend('Experimental Data', 'WLSE Curve Fit', 'LSE Curve Fit');
xlabel('Input Power (dBm)'); ylabel('Output Power (dBm)');