%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 3 - Section 2: Equiripple Filter Design
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code - Slightly Modified (Page 194)

%% Defining The Response --> Tap length is N = 15 (odd number)
%% We directly control (N+1)/2 coefficients via (N+1)/2 +1 constraints

%F1P = [0.0 .1 .15 .2]; F1S = [.3 .35 .4 .45 .5];    %% Initial Guess
F1P = [0.05 .11 .18 .2]; F1S = [.3 .32 .38 .44 .5];  %% Refined Guess
F = [ F1P F1S].';                             %% 9 constraints
H = [ 1 1 1 1   0 0 0 0 0].';                 %% Frequency Response
A = [1 -1 1 -1  1 -1 1 -1 1].';               %% Alternating +/- 1
 
%% Initial Solution

X = [2*cos(2*pi.*F*7) 2*cos(2*pi.*F*6) 2*cos(2*pi.*F*5) ...
     2*cos(2*pi.*F*4) 2*cos(2*pi.*F*3) 2*cos(2*pi.*F*2) ...
     2*cos(2*pi.*F*1) ones(9,1) A];   %% Building Matrix X
CE = inv(X)*H;                        %% Solve for the CE Vector

Coefficients  = [CE(1:8,1); flipud(CE(1:7,1))].'; %% Extract C
MinimaxError  = CE(9,1);                          %% Extract E

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code - Slightly Modified (Page 194 - 195)

f        = 0:.001:0.5;                            %% Test Frequencies
N        = length(Coefficients);
n        = -7:7;
Actual   = zeros(1,length(f));
    
for i = 1:length(f)                                     
     AnalysisTone  = exp(j*2*pi*n*f(1,i));
     Actual(1,i)   = Coefficients*AnalysisTone';  %% DTFT operations     
end

%figure(1);
%plot(f, real(Actual), 'k',  'LineWidth', 1); grid on; hold on;
%plot(f, imag(Actual), 'b');


figure(2);
subplot(2,1,1);
plot(f, 20*log10(abs(Actual)), 'k',  'LineWidth', 1); grid on; title('Magnitude Response');
axis([0 0.5 -50 10]); xlabel('Normalized Frequency'); ylabel('dB');
set(gca,  'LineWidth', 1);
set(gca,  'LineWidth', 1);
subplot(2,1,2);
plot(f, 20*log10(abs(Actual)), 'k',  'LineWidth', 1); grid on; title('Magnitude Response');
axis([0 0.5 -50 10]); xlabel('Normalized Frequency'); ylabel('dB');
set(gca,  'LineWidth', 1);
set(gca,  'LineWidth', 1);

 

%% Calculate Pass and Stop band error

fpass      = 0.0:.001:.2;     %% Analysis Frequencies
z          = exp(j*2*pi*fpass);   
ActualPass = zeros(1,length(fpass));

for i = 1:length(Coefficients)
    ActualPass = ActualPass + Coefficients(1,i)*z.^-(i-8);
end

fstop      = 0.3:.001:.5;     %% Analysis Frequencies
z          = exp(j*2*pi*fstop);   
ActualStop = zeros(1,length(fstop));

for i = 1:length(Coefficients)
    ActualStop = ActualStop + Coefficients(1,i)*z.^-(i-8);
end

ErrorPass = ActualPass - ones(size(ActualPass));
ErrorStop = ActualStop - zeros(size(ActualStop));

EP        = interp1(fpass, ErrorPass, F1P,'spline');
ES        = interp1(fstop, ErrorStop, F1S,'spline');

figure(2);
plot(fpass, ErrorPass, 'k', 'LineWidth', 1); grid on; hold on;
plot(F1P, EP, 'ko', 'LineWidth', 1);
plot(fstop, ErrorStop, 'k', 'LineWidth', 1);
plot(F1S, ES, 'ko', 'LineWidth', 1);
title('Error Curve E(f) = Actual(f) - Desired(f)'); xlabel('Normalized Frequency');
M = abs(MinimaxError);
set(gca, 'YTick', [ -2*M -M 0 M 2*M],  'LineWidth', 1);
set(gca, 'XTick', [0 .1 .2 .3 .4 .5],  'LineWidth', 1);
set(gca,  'LineWidth', 1);

%figure(2);
%subplot(2,1,1);
%plot(f, abs(Actual), 'r'); grid on; 
%subplot(2,1,2);
%plot(f, angle(Actual), 'b');

figure(3);
subplot(2,1,1);
stem(-7:7, Coefficients,'k', 'LineWidth', 1);  title('Initial Coefficients');
xlabel('Discrete Time'); axis([ -8 8 -0.2 0.6]);
subplot(2,1,2);
plot(f, real(Actual), 'k', 'LineWidth', 1); grid on; axis([0 0.5 -.1 1.1]);
set(gca, 'YTick', [ 0  1.0]);
set(gca, 'XTick', [0 .1 .2 .3 .4 .5]);
xlabel('Normalized Frequency');
title('Real Part of Frequency Response');