%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 3 - Section 2:  Minimax Approximation using Remez Exchange 
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 188 - 189)

%% Set up the curve to be fitted

x      = 0:.01:4;            %% independent variable
F      = 1./(1 + 25*x.^2);   %% Test Function
Order  = 5;                  %% Polynomial order of fit
RemezIterations = 5;         %% Let's try just 5 for now
a = x(1);  b = x(length(F)); 

%%

Sign   = ((-1).^(0:1:Order+1))';      %% Column sign vector
NumberPoints = Order + 2;
Ind     = [1 68 134 201 268 334 401]; %% Let's pick starting indices
F_guess = F(1, Ind)';                 %% Select Points of Test Function
x_guess = x(1,Ind)';                  %% Select accompanying x  coordinates
%CurrentPoints = Curve(1, GuessIndex)';         %% The current
%CurrentIndex  = x(1,GuessIndex)';

ActivateGraphs = 1;
Ind = [];
for n = 1:RemezIterations
    X = ones(NumberPoints,1);   %% Build system of equations for the
    for z = 1:Order             %% current Remez Iteration
        X = [X x_guess.^z];
    end
    X  = [X Sign];
    CE = inv(X)*F_guess;        %% Here we solve for the coefficients
    C  = CE(1:Order+1,1);       %% Extracting the polynomial coefficients
    E  = CE(Order+2,1);         %% Extracting the error
    
    P1 = polyval(flipud(C),x_guess); %% Eval only at select points
    P2 = polyval(flipud(C),x);       %% Eval for large index
    Error1 = F_guess - P1;           %% Error only at select points
    Error2 = F - P2;                 %% Error for large index
    
    %%  Graphing Section --> To see whether our calculation make sense
        
    if(n==2)
        close(figure(1)); figure(1); hold on; grid on;
        plot(x,P2,'r');
        plot(x_guess, P1,'ro');
        plot(x,F,'b');
        plot(x_guess, F_guess,'bo');
        title('Original and Polyfit curves');
        close(figure(2)); figure(2); 
        subplot(2,1,1);
        plot(x, Error2,'k', 'LineWidth', 1); hold on; grid on;
        plot(x_guess, Error1,'ko', 'LineWidth', 1); xlabel('x');
        title('Error Curve after one Remez Exchanges');
    end
    if(n==5)
        subplot(2,1,2);
        plot(x, Error2,'k', 'LineWidth', 1); hold on; grid on;
        plot(x_guess, Error1,'ko', 'LineWidth', 1); xlabel('x');
        title('Error Curve after four Remez Exchanges');
    end
    
    %% Start Remez Exchange --> Step One: Get the Roots of the Error2 curve
    
    Ind = Remez(Error2, Order, Ind);
    x_guess  = x(1,Ind)';
    F_guess  = F(1,Ind)';
end


