%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 3 - Section 2:  Minimax Approximation Example 3.3 
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 186-187)

%% Set up the curve to be fitted
x      = 0:.01:4;            %% Depedent variable 
F      = 1./(1 + 25*x.^2);   %% Test Function

Ind     = [1 68 134 201 268 334 401]; %% Starting indices for equal spacing
x_guess = x(1,Ind)';                  %% = [0 .67 1.33 2.0 2.67 3.33 4.0]
F_guess = F(1, Ind)';                 %% Test function values at x_guess

Order      = 5;
Sign       = ((-1).^(0:1:Order+1))';  %% The needed sign vector
X = ones(Order+2,1);                  %% Building the matrix X
for n = 1:Order
   X = [X x_guess.^n];
end
X = [X Sign];                         %% Adding the Sign Vector
 
CE = inv(X)*F_guess;                  %% Calculating Solution Vector
C  = CE(1:Order+1,1);                 %% Extracting the coefficients


%% Rendering the Curves and calculating errors
P1 = polyval(flipud(C),x_guess); %% Eval only at select points
P2 = polyval(flipud(C),x);       %% Eval for large index
Error1 = P1 - F_guess;           %% Error only at select points
Error2 = P2 - F;                 %% Error for large index

figure(1);
plot(x,P2,'k'); hold on;
plot(x_guess, P1,'ko');
plot(x,F,'k--');
plot(x_guess, F_guess,'kx');
title('LSE and Minimax Approximation Side by Side');
legend( 'Minimax Approximation', 'Selected Minimax Locations', ...
        'Original Function', 'Selected Original Locations');

figure(2); 
plot(x, Error2,'k', 'LineWidth', 1); hold on; grid on;
plot(x_guess, Error1,'ko', 'LineWidth', 1); xlabel('x'); ylabel('Error');
title('Error Curve for Polynomial Coefficients C');


        
