%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 3 - Section 3:  Algebraic and Lagrange Interpolation
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 201)

%% The Coordinates
X = [0 1 2 3].';  %% X and Y coordinates of the four points
Y = [1 3 2 2].';  %% as column vectors

%% The Desired x coordinate at which we interpolate
x = 1.5;

%% Solution via the algebraic form of the polynomial

F           = [ones(4,1) X  X.^2 X.^3];
A           = inv(F)*Y;

y_Algebraic = [1 x x^2 x^3]*A;

%% Solution via the Lagrange form of the polynomial

b0          = -(1/6)*(x-1)*(x-2)*(x-3);
b1          =  (1/2)*x*(x-2)*(x-3);
b2          = -(1/2)*x*(x-1)*(x-3);
b3          =  (1/6)*x*(x-1)*(x-2);

y_Lagrange  = Y.' * [b0; b1; b2; b3];

display(['Algebraic: ' num2str(y_Algebraic)]);
display(['Lagrange:  ' num2str(y_Lagrange)]);

return   %% Remove this line for additional functionality

clc;
clear all;
close all;

%% The Coordinates
X = [0 1 2 3].';  %% X and Y coordinates of the four points
Y = [1 3 2 2].';  %% as column vectors

%% The Desired x coordinate at which we interpolate
Alg = [];
Lag = [];

for x = 0:.1:3;
    %% Solution via the algebraic form of the polynomial

    F           = [ones(4,1) X  X.^2 X.^3];
    A           = inv(F)*Y;

    y_Algebraic = [1 x x^2 x^3]*A
    Alg         = [Alg y_Algebraic];
    %% Solution via the Lagrange form of the polynomial

    b0          = -(1/6)*(x-1)*(x-2)*(x-3);
    b1          =  (1/2)*x*(x-2)*(x-3);
    b2          = -(1/2)*x*(x-1)*(x-3);
    b3          =  (1/6)*x*(x-1)*(x-2);

    y_Lagrange  = Y.' * [b0; b1; b2; b3]
    Lag         = [Lag y_Lagrange];
end

figure(1);
plot(0:.1:3, Alg, 'k'); grid on; hold on;
plot(0:.1:3, Lag, 'ro');


