%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 3 - Section 4: Half-Band Filter
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013


clc;
clear all;
close all;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 214)

N    = 15;                                  % Number of Taps
n    = 0:N-1;
Arg  = n/2 - (N-1)/4;                       % Argument inside sinc function
Hann = (ones(1,N) - cos(2*pi*(n+1)/(N+1))); % The Hanning window as a row 
                                            % vector


%% Half Band Filter Impulse Response
h   = sinc(Arg).*Hann; 
h   = h/sum(h);  %% normalize to unity DC gain

%% Computing the Frequency Response
FResolution = 0.002;
Frequencies = -0.5:FResolution:0.5;
FrequencyResponse = zeros(1,length(Frequencies));

for i = 1:length(Frequencies)                 %% The DTFT Operation
    f                      = Frequencies(1,i);
    AnalysisTone           = exp(j*2*pi*n*f);
    FrequencyResponse(1,i) = h*AnalysisTone';
end
LogResponse = 20*log10(abs(FrequencyResponse));

xi = 0:0.1:N-1;
yi = interp1(n, h, xi, 'spline');

figure(1);
subplot(1,2,1)
stem(n, h, 'k', 'LineWidth', .8); hold on;
plot(xi, yi, 'k--', 'LineWidth', .8);
title('Impulse Response of Halfband Filter'); xlabel('n');
axis([0 N-1 -.1 .6])
set(gca,  'LineWidth', 1);
subplot(1,2,2); 
plot(Frequencies, LogResponse, 'k', 'LineWidth', .8); grid on;
title('Normalized Magnitude Response of Half Band filter');
set(gca, 'XTick', [-.5 -.25 0 .25 .5]); xlabel('Normalized Frequency');
ylabel('dB');axis([([-.5 .5]) -60 5]);
set(gca,  'LineWidth', 1);

