%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 4 - Section 1/2:  Zero Forcing and LSE Equalizer Example
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Pages 219-223)


%% 1. Input symbol and Distorting Channel definitions
In       = [1 1 -1 -1 -1 1 -1 -1 1 -1 1 1 1 -1 1 -1 -1 -1 1 1 -1 1 1 -1 1 ...
            -1 -1 -1 1 -1 -1 1 1 -1 1 1 1 1 -1 1 1 -1] ; %% Random +/-1 samples
Channel  = [.1 -.1 .05 1 .05];         %% The coefficients of our 
                                       %% Distorting FIR filter                                  
y        = filter(Channel, 1, In);     %% The Observed sequence

figure(1);
subplot(1,2,1);
stem(In(1,1:30), 'k'); grid on; title('Input Sequence In[n]');
axis([1 30 -1.5 1.5]);
set(gca, 'XTick', [0 10 20]);
set(gca, 'YTick', [-1 1]);

subplot(1,2,2);
stem(y, 'k'); grid on; title('Observed Sequence  y[n]');
axis([1 30 -1.5 1.5]);
set(gca, 'XTick', [0 10 20]);
set(gca, 'YTick', [-1 1]);

 
              
%% 2. Here we compute the Zero-Forcing Solution     
y        = y(1,3:40);               %% Remove intial zeros
Y     = toeplitz([y(1,6) y(1,7) y(1,8) y(1,9) y(1,10) y(1,11)], ...
                 [y(1,6) y(1,5) y(1,4) y(1,3) y(1,2) y(1,1)] ) ;                   
C     = inv(Y)*In(1,1:6)'           %% Computing the solution
E_In  = filter(C, 1, y);            %% Passing the observed samples
                                    %% through our estimation FIR
Error1= In(1,1:30) - E_In(1,6:35);  %% Used for RMS error calculation                          
 
figure(2);
stem(E_In(1,1:30), 'k'); grid on; title('Zero-Forcing Estimate of In[n]');
axis([1 30 -1.5 1.5]); set(gca, 'LineWidth', 1.0);


%% 3. Here we compute the LSE Solution     
Y     = toeplitz(y(1,6:30), [y(1,6) y(1,5) y(1,4) y(1,3) y(1,2) y(1,1)]);
C     = inv(Y'*Y)*Y'*In(1,1:25)'
E_In  = filter(C, 1, y);            %% Filtering the observed samples
Error2= In(1,1:30) - E_In(1,6:35);  %% Used for RMS error calculation                 

figure(3);
stem(E_In(1,1:30), 'k', 'LineWidth', 0.9); grid on; title('Least Squares Error Estimate of In[n]');
axis([1 30 -1.5 1.5]); set(gca, 'LineWidth', 0.8);