%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 4 - Section 2:  Channel Estimation
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                          Date: May 2013

clc;
clear all;
close all;


%% 4. The Channet Estimation Task
In       = [1 1 -1 -1 -1 1 -1 -1 1 -1 1 1 1 -1 1 -1 -1 -1 1 1 -1 1 1 -1 1 ...
            -1 -1 -1 1 -1 -1 1 1 -1 1 1 1 1 -1 1 1 -1] ; %% Random +/-1 samples
Channel = [.1 -.1 0.05 1+j .05];
%Channel  = [.1 -.1 .05 1 .05];        %% The coefficients of our 
                                       %% Distorting FIR filter                                  
y          = filter(Channel, 1, In);   %% The Observed sequence
L          = 30;                       %% Number of observations used  
IN         = toeplitz(In(1,1:L), [In(1,1) 0 0 0 0 0]);
Y          = y(1,1:L).';
H_Estimate = inv(IN'*IN)*IN'*Y;

display(['Estimated Channel Response: [' num2str(H_Estimate.') ']']);