%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 5 - Section 3:  Cause_TimingDrift Function
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 293)

function Output = Cause_TimingDrift(Input, Drift)
% Input --> Input Sequence
% Drift --> in parts per million (ppm)

SampleStep  = 1 + Drift/1e6;

InputIndex  = 1:length(Input);
OutputIndex = 1:SampleStep:length(Input); 

Output      = interp1(InputIndex, Input, OutputIndex, 'spline');