%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 5 - Section 3: Defect Model Test Bench
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 295-296)


clc;
clear all;
close all;

%% 1.  Transmitter Setup
%  1a. General Setup Information
ModulationFormat = 1;    % 0/1/2/3  =  BPSK/QPSK/8PSK/16QAM
NumberOfSymbols  = 300;
Alpha            = 0.5;  % This is the raised cosine index
Delay            = 4;    % Recommended -> Delay = 3 for Alpha > .3
                         % Recommended -> Delay = 6 for .1 > Alpha > .3
                         % Recommended -> Delay > 6 for Alpha < .1
OSR              = 4;    % Recommended --> 4 or 8
SymbolRate       = 10e6; 
SampleRate       = SymbolRate*OSR;
 

% 1b. Generate Random bits
InputBits        = round(rand(1, NumberOfSymbols*(ModulationFormat + 1)));

% 1c. The Mapping Operation
[MapperSymbols]  = Mapper(InputBits, ModulationFormat);
 
% 1d. The Zero-Stuffing and Pulse Shaping Operation
[TX_Samples]    = TX_Waveform_Mapping([MapperSymbols 0 0 0 0 0 0 0 0], ...
                                                       OSR, Alpha, Delay);
Range           = 21:OSR:540;  % Waveform indices at which the waveform
                               % sample is equal to the symbol                               
%% 2. Defect Model 
% 2a. Configuring the Default Model
Mode.Multipath             = 0;          % 0/1 = exclude/include defect
Mode.ThermalNoise          = 1;
Mode.PhaseNoise            = 1;
Mode.Freq_Offset           = 0;
Mode.IQ_Imbalance          = 0;
Mode.TimingOffset          = 0;
Mode.TimingDrift           = 0;
 
Settings.SampleRate        = 40e6;        % Hertz
Settings.NumberOfTaps      = 40;          % For Multipath Model 
Settings.DelaySpread       = 5e-9;      % Seconds
Settings.SNR_dB            = 50;          % AWG Thermal Noise
Settings.PhaseNoiseProfile = [1e3 10e3 20e3 35e3 50e3 80e3 90e3 100e3 ...
                              120e3 150e3 200e3 300e3 500e3 1e6; ...
                              -70 -72 -72 -74 -76 -85 -90 -95 ...
                               -100 -105   -110 -120 -130 -140];                               
Settings.FrequencyOffset    = -100e3;     % Hz
Settings.PhaseImbalance     = pi/2000;    % radians
Settings.AmplitudeImbalance_dB = -.1;     % dB
Settings.Sample_Offset      = -1;         % samples at the sample rate  
Settings.Drift_ppm          = -80;        % given above in ppm (parts per
                                          % million
% 2b. Applying the Default Model
[TX_Output FIR_Taps]   = Defect_Model(TX_Samples, Settings, Mode);  

figure(2);
subplot(2,2,1);
plot(real(TX_Output), 'k'); grid on; hold on;
plot(Range, real(TX_Output(1,Range)), 'ko'); title('I Portion of Sample Stream');
set(gca, 'YTick', [-.707 0 .707]); 
axis([0 150 -1 1]);
subplot(2,2,3);
plot(imag(TX_Output), 'k');grid on; hold on;
plot(Range, imag(TX_Output(1,Range)), 'ko'); title('Q Portion of Sample Stream');
set(gca, 'YTick', [-.707 0 .707]); 
axis([0 150 -1 1]);
subplot(2,2,[2 4]);
plot(real(TX_Output), imag(TX_Output), 'k:');grid on; hold on;
plot(real(TX_Output(1,Range)), imag(TX_Output(1,Range)), 'ko', 'MarkerSize', 10, 'Linewidth', 3);
title('Constellation with Signal Traces');
axis([-1.2 1.2 -1.2 1.2]);
set(gca, 'XTick', [-.707 0 .707]); 
set(gca, 'YTick', [-.707 0 .707]); 
