%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 5 - Section 3:  Phase Noise Generator Testbench
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 284)

SampleRate      = 10e6;  %% Output Sample Rate 
NumberOfSamples = 1e6;   %% Number of samples in simulation

dBc   = [ -85 -85  -80  -80  -90  -100    -115  -130 ];  %% Desired Phase
Freq  = [ 1e3 20e3 30e3 40e3 70e3 100e3  200e3  1000e3]; %% Noise Profile

[Out Pow_Pos Freq_Pos RMSN] = PhaseNoiseGenerator(SampleRate, ...
                                          NumberOfSamples, dBc, Freq);

Carrier = exp(j*Out);   %% Phasor expression of the Carrier 

display(['Calculated RMS phase noise (degrees): ' num2str(RMSN*57.29)]);
display(['Measured RMS Phase Noise (degrees): ' num2str(57.29*sqrt(var(Out)))]);

Points  = 8*1024;
[Mag f] = Spectrum_Fast(Carrier,Points, SampleRate);

figure(10);
semilogx(Freq, dBc, 'k', 'LineWidth', 2); hold on; grid on;
semilogx(f, Mag - 10*log10(SampleRate/Points), 'k'); 
title('Normalized Power Spectral Density of Carrier');
axis([1e3 2e6 -130 -60]); 
legend('Desired Noise Profile', 'Normalized Carrier PSD');

length(Out)
