%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 5 - Section 4: High Pass Frequency Response
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

close all;
clear all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 300-301)

%% 0. Set Frequency Range over which to sweep
SampleRate = 10e6;             
fnorm      = .0001:.0001:.5;    %% Normalized Frequency
f          = fnorm*SampleRate;  %% Actual Frequency
s          = j*2*pi*f;          
z          = exp(j*2*pi*fnorm);
 
%% 1. Define analog high pass structure
G1         = 1;      % R3/R1  unity gain high pass structure
G2         = 2;      % R3/R2
C          = 3.2e-9;
R          = 1000;
A_Pole     = -G2/(R*C);          %% Analog Pole location s = -G2/(R*C)
Corner3dB  = abs(A_Pole)/(2*pi); %% 3dB Corner Frequency Hertz

Hs = (-G1*s)./(s + G2/(R*C));    %% The analog high pass transfer function
 
%% 1b. Calculate The Analog Frequency Response
MagResponseS   = 20*log10(abs(Hs));     
PhaseResponseS = angle(Hs);   
 
%% 2. Defining the high pass structure
Ts         = 1/SampleRate;    %% Sample Period
D_Pole     = exp(A_Pole*Ts);  %% z = 1 - A = D_Pole
A          = 1 - D_Pole;
MaxGainDig = -2/(-2 + A);
D          = - G1/MaxGainDig;
 
Hz = D*(z-1)./(z-1+A);         %% The discrete high pass transfer function
     
%% 2b. Calculate The Discrete Frequency Response
MagResponseZ    = 20*log10(abs(Hz));  %% Discrete Magnitude Response
PhaseResponseZ  = angle(Hz);          %% Discrete Phase Response
 
figure(2);
semilogx(f, MagResponseZ,'k'); grid on; hold on;
semilogx(f, MagResponseS,'ko'); title('Magnitude Responses');
legend('Discrete','Continuous');
xlabel('f'); ylabel('dB');
display(['Corner Frequency (Hz): ' num2str(Corner3dB)]);
display(['A: ' num2str(A) '      D: ' num2str(D)]);
axis([1e3 5e6 -40 0]);







