%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 5 - Section 3:  FIR Interpolator Function
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 292)

function [Output] = FIR_Interpolator(Input , SampleDelay)
 
N     = 11;                          %% Easier if odd number of taps      
m     = -(floor(N/2)):1:floor(N/2);  %% Frequency index m
Mag   = ones(1, N);                  %% Magnitude response
Phase = -2*pi*m*SampleDelay/N;       %% Linear phase response
X     = Mag.*cos(Phase) + j*Mag.*sin(Phase);
                                     %% Total frequency response
DiscreteTime = -(floor(N/2)):1:floor(N/2); %% Time index    
h = zeros(1,N);           %% Place holder for impulse response
    
%% Inverse discrete Fourier transform (compute impulse response)
for i=1:N            
     n      = DiscreteTime(1,i);   
     h(1,i) = X*exp(j*2*pi*m*n/N).'; %% The correlation equation
end        

%% Overlay the Hanning window on top of impulse response
Hanning = hann(N+2)';
FIR_Coefficients = h.*Hanning(1,2:end-1);
FIR_Coefficients = real(FIR_Coefficients ... %% Normalizing
                   /sum(FIR_Coefficients) );
 
%% Filtering operation
Output = filter(FIR_Coefficients, 1, Input);
