%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 5 - Section 3: Get Mulipath filter function
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger  


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 272)


function FIR_Taps = GetMultipathFilter(SampleRate, DelaySpread, N)

Ts          = 1/SampleRate; %% Sampling Period in seconds
Trms        = DelaySpread;  %% Delay spread in seconds

n = 0:N-1;

ExpVariance = exp(-n*Ts/Trms);
FIR_Taps    = zeros(1,N);

for i = 1:N
    FIR_Taps(1,i) = sqrt(ExpVariance(1,i))*randn(1,1) + ...
                  j*sqrt(ExpVariance(1,i))*randn(1,1);
end