%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 5 - Section 3:  IQ Imbalance Function
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 289)

function [I_Out Q_Out] = IQImbalance(I, Q ,IQPhaseError, ...
                                         IQAmplitudeError)
 
I_Temp = I+Q*sin(IQPhaseError);         %% Simulate IQ Phase
Q_Temp = Q*cos(IQPhaseError);           %% Imbalance
 
I_Out  = (1+IQAmplitudeError/2)*I_Temp; %% Simulate IQ 
Q_Out  = (1-IQAmplitudeError/2)*Q_Temp; %% Amplitude Imbalance
