%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 5 - Section 3:  Cause_TimingOffset Function
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 292)

function Output = Cause_TimingOffset(Input, SampleDelay)
% Input  --> Input Sequence
% Offset --> Offset in Samples  

SampleStep  = 1;
InputIndex  = 1:length(Input);
OutputIndex = 1+ SampleDelay:SampleStep:length(Input); 
 
Output      = interp1(InputIndex, Input, OutputIndex, 'spline');
