%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 6 - Section 1.1
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Undocumented Code (Page 320-322)


%% 1. Generating the Transmit Waveform
%  1a. General Setup Information

ModulationFormat = 2;    % 0/1/2/3  =  BPSK/QPSK/8PSK/16QAM
NumberOfSymbols  = 300;
Alpha            = 0.5;  % This is the raised cosine index
Delay            = 4;    % Recommended -> Delay = 3 for Alpha > .3
                         % Recommended -> Delay = 6 for .1 > Alpha > .3
                         % Recommended -> Delay > 6 for Alpha < .1
OSR              = 4;    % Recommended --> 4 or 8
SymbolRate       = 10e6; 
SampleRate       = SymbolRate*OSR;

% 1b. Generate Random bits
InputBits        = round(rand(1, NumberOfSymbols*(ModulationFormat + 1)));

% 1c. The Mapping Operation
%[MapperSymbols]  = Mapper(InputBits, ModulationFormat);
[MapperSymbols]  = .707*[1-j -1+j 1+j -1+j 1-j 1+j -1-j -1+j];

% 1d. The Zero-Stuffing and Pulse Shaping Operation
[TX_Samples1]     = TX_Waveform_Mapping([MapperSymbols(1,1)   0 0 0 0 0 0 0 0  0 0 0 0 0], ...
                                                       OSR, Alpha, Delay);
                                                   
[TX_Samples2]     = TX_Waveform_Mapping([0 MapperSymbols(1,2)   0 0 0 0 0 0  0 0 0 0 0 0 0 ], ...
                                                       OSR, Alpha, Delay);
                                                   
[TX_Samples3]     = TX_Waveform_Mapping([0 0 MapperSymbols(1,3)  0 0 0 0 0 0 0 0 0 0 0 ], ...
                                                       OSR, Alpha, Delay);
                                                   
[TX_Samples]     = TX_Waveform_Mapping([MapperSymbols  0 0 0 0 0 0 0 0 0], ...
                                                       OSR, Alpha, Delay);
                                                   
Range            = 21:OSR:60;  % Waveform indices at which the waveform
                               % sample is equal to the symbol
            
                               
figure(8);
subplot(1,2,1);
stem(0:7, real(MapperSymbols(1,1:8)), 'k', 'LineWidth', 0.90); grid on; hold on; title('Real Portion of Symbol Stream'); set(gca,  'LineWidth', 1);
subplot(1,2,2);
stem(0:7, imag(MapperSymbols(1,1:8)), 'k', 'LineWidth', 0.90); grid on; hold on; title('Imaginary Portion of Symbol Stream');
set(gca,  'LineWidth', 1);

figure(1);
subplot(2,2,1);
stem(real(MapperSymbols(1,1:8)), 'k'); grid on; hold on; title('Real Portion of Symbol Stream');
subplot(2,2,3);
stem(imag(MapperSymbols(1,1:8)), 'k'); grid on; hold on; title('Imaginary Portion of Symbol Stream'); set(gca,  'LineWidth', 1);
subplot(2,2,2);
plot(real(TX_Samples), 'k'); grid on; hold on;
plot(Range, real(TX_Samples(1,Range)), 'ko'); title('I Portion of T\_Domain(n)');
set(gca, 'YTick', [-.707 0 .707]); set(gca,  'LineWidth', 1);
axis([0 60 -1 1]);
subplot(2,2,4);
plot(imag(TX_Samples), 'k');grid on; hold on;
plot(Range, imag(TX_Samples(1,Range)), 'ko'); title('Q Portion of T\_Domain(n)');
set(gca, 'YTick', [-.707 0 .707]); 
axis([0 60 -1 1]); set(gca,  'LineWidth', 1);

figure(6);
subplot(4,1,1);
plot(real(TX_Samples1), 'k'); grid on; hold on;
plot(imag(TX_Samples1), 'k:', 'LineWidth', 2); 
plot(21, real(TX_Samples1(1,21)), 'ko');  
plot(21, imag(TX_Samples1(1,21)), 'ko'); 
title('Single Tone - Pulse Shaped Symbol: C[0] = +1-j');
axis([10 55 -1 1]); set(gca,  'LineWidth', 1);
subplot(4,1,2);
plot(real(TX_Samples2), 'k'); grid on; hold on;
plot(imag(TX_Samples2), 'k:', 'LineWidth', 2); 
plot(25, real(TX_Samples2(1,25)), 'ko');  
plot(25, imag(TX_Samples2(1,25)), 'ko'); 
title('Single Tone - Pulse Shaped Symbol: C[1] = -1+j');
axis([10 55 -1 1]); set(gca,  'LineWidth', 1);
subplot(4,1,3);
plot(real(TX_Samples3), 'k'); grid on; hold on;
plot(imag(TX_Samples3), 'k:', 'LineWidth', 2); 
plot(29, real(TX_Samples3(1,29)), 'ko');  
plot(29, imag(TX_Samples3(1,29)), 'ko'); 
title('Single Tone - Pulse Shaped Symbol: C[2] =  1+j');
axis([10 55 -1 1]); set(gca,  'LineWidth', 1);
subplot(4,1,4);
plot(real(TX_Samples), 'k'); grid on; hold on;
plot(imag(TX_Samples), 'k:', 'LineWidth', 2); 
plot([21 25 29 33 37 41 45 49], real(TX_Samples(1,[21 25 29 33 37 41 45 49])), 'ko');
plot([21 25 29 33 37 41 45 49], imag(TX_Samples(1,[21 25 29 33 37 41 45 49])), 'ko');
title('Single Tone - Summed Symbols');
axis([10 55 -1 1]); set(gca,  'LineWidth', 1);



Symbols = [-1 + j; -1 - j; 1 + j]/sqrt(2);
N       = 8;
n       = 0:1:(N-1);

Waveform1 = MapperSymbols(1,1)*exp(j*2*pi*n*0/N);
Waveform2 = MapperSymbols(1,2)*exp(j*2*pi*n*1/N);
Waveform3 = MapperSymbols(1,3)*exp(j*2*pi*n*2/N);
Waveform4 = MapperSymbols(1,4)*exp(j*2*pi*n*3/N);
Waveform5 = MapperSymbols(1,5)*exp(-j*2*pi*n*4/N);
Waveform6 = MapperSymbols(1,6)*exp(-j*2*pi*n*3/N);
Waveform7 = MapperSymbols(1,7)*exp(-j*2*pi*n*2/N);
Waveform8 = MapperSymbols(1,8)*exp(-j*2*pi*n*1/N);
Waveform9 = Waveform1 + Waveform2 + Waveform3 + Waveform4 + ...
            Waveform5 + Waveform6 + Waveform7 + Waveform8;

nn      = 0:.1:(N-1);

Waveform1n = MapperSymbols(1,1)*exp(j*2*pi*nn*0/N);
Waveform2n = MapperSymbols(1,2)*exp(j*2*pi*nn*1/N);
Waveform3n = MapperSymbols(1,3)*exp(j*2*pi*nn*2/N);
Waveform4n = MapperSymbols(1,4)*exp(j*2*pi*nn*3/N);
Waveform5n = MapperSymbols(1,5)*exp(-j*2*pi*nn*4/N);
Waveform6n = MapperSymbols(1,6)*exp(-j*2*pi*nn*3/N);
Waveform7n = MapperSymbols(1,7)*exp(-j*2*pi*nn*2/N);
Waveform8n = MapperSymbols(1,8)*exp(-j*2*pi*nn*1/N);
Waveform9n = Waveform1n + Waveform2n + Waveform3n + Waveform4n + ...
             Waveform5n + Waveform6n + Waveform7n + Waveform8n;


figure(2);
subplot(4,1,1);
plot(n,real(Waveform1),'ko');  hold on;
plot(nn,real(Waveform1n), 'k');
plot(n,imag(Waveform1), 'ko');
plot(nn,imag(Waveform1n), 'k--'); 
title('Multitone - OFDM Symbol:  C[0] = +1-j'); axis([0 8 -1.2 1.2]);set(gca,  'LineWidth', 1);
subplot(4,1,2);
plot(n,real(Waveform2),'ko');  hold on;
plot(nn,real(Waveform2n), 'k');
plot(n,imag(Waveform2), 'ko');
plot(nn,imag(Waveform2n), 'k--'); 
title('Multitone - OFDM Symbol:  C[1] = -1+j'); axis([0 8 -1.2 1.2]);set(gca,  'LineWidth', 1);
subplot(4,1,3);
plot(n,real(Waveform3),'ko');  hold on;
plot(nn,real(Waveform3n), 'k');
plot(n,imag(Waveform3), 'ko');
plot(nn,imag(Waveform3n), 'k--');
title('Multitone - OFDM Symbol:  C[3] = +1+j'); axis([0 8 -1.2 1.2]);set(gca,  'LineWidth', 1);
subplot(4,1,4);
plot(n,real(Waveform9),'ko');  hold on;
plot(nn,real(Waveform9n), 'k');
plot(n,imag(Waveform9), 'ko');
plot(nn,imag(Waveform9n), 'k--'); 
title('Multitone - 8 Summed Symbols '); axis([0 8 -5 5]);set(gca,  'LineWidth', 1);


figure(16);
subplot(4,2,1);
plot(real(TX_Samples1), 'k', 'LineWidth', 0.9); grid on; hold on;
plot(imag(TX_Samples1), 'k--', 'LineWidth',0.9); 
plot(21, real(TX_Samples1(1,21)), 'ko', 'LineWidth', 0.9);  
plot(21, imag(TX_Samples1(1,21)), 'ko', 'LineWidth', 0.9); 
title('Single Tone - Input Symbol: C[0] = +1-j');
legend('Real','Imag'); set(gca,  'LineWidth', 1.1);
axis([10 55 -1 1]); 
subplot(4,2,3);
plot(real(TX_Samples2), 'k', 'LineWidth', 0.9); grid on; hold on;
plot(imag(TX_Samples2), 'k--', 'LineWidth', 0.9);
plot(25, real(TX_Samples2(1,25)), 'ko', 'LineWidth', 0.9);  
plot(25, imag(TX_Samples2(1,25)), 'ko', 'LineWidth', 0.9); 
title('Single Tone - Input Symbol: C[1] = -1+j'); set(gca,  'LineWidth', 1.1);
axis([10 55 -1 1]); 
subplot(4,2,5);
plot(real(TX_Samples3), 'k', 'LineWidth', 0.9); grid on; hold on;
plot(imag(TX_Samples3), 'k--', 'LineWidth', 0.9); 
plot(29, real(TX_Samples3(1,29)), 'ko', 'LineWidth', 0.9);  
plot(29, imag(TX_Samples3(1,29)), 'ko', 'LineWidth', 0.9); 
title('Single Tone - Input Symbol: C[2] =  1+j'); set(gca,  'LineWidth', 1.1);
axis([10 55 -1 1]); 
subplot(4,2,7);
plot(real(TX_Samples), 'k', 'LineWidth', 0.9); grid on; hold on;
plot(imag(TX_Samples), 'k--', 'LineWidth', 0.9); 
plot([21 25 29 33 37 41 45 49], real(TX_Samples(1,[21 25 29 33 37 41 45 49])), 'ko');
plot([21 25 29 33 37 41 45 49], imag(TX_Samples(1,[21 25 29 33 37 41 45 49])), 'ko');
title('Single Tone - 8 Summed Symbols'); set(gca,  'LineWidth', 1.1);
axis([10 55 -1 1]);

subplot(4,2,2);
plot(4*n,real(Waveform1),'ko', 'LineWidth', 0.9);  hold on;
plot(4*nn,real(Waveform1n), 'k', 'LineWidth', 0.9);
plot(4*n,imag(Waveform1), 'ko', 'LineWidth', 0.9);
plot(4*nn,imag(Waveform1n), 'k--', 'LineWidth', 0.9); 
title('Multitone - Input Symbol:  C[0] = +1-j'); axis([0 32 -1.2 1.2]); set(gca,  'LineWidth', 1.1);
subplot(4,2,4);
plot(4*n,real(Waveform2),'ko', 'LineWidth', 0.9);  hold on;
plot(4*nn,real(Waveform2n), 'k', 'LineWidth', 0.9);
plot(4*n,imag(Waveform2), 'ko', 'LineWidth', 0.9);
plot(4*nn,imag(Waveform2n), 'k--', 'LineWidth', 0.9); 
title('Multitone - Input Symbol:  C[1] = -1+j'); axis([0 32 -1.2 1.2]);set(gca,  'LineWidth', 1.1);
subplot(4,2,6);
plot(4*n,real(Waveform3),'ko', 'LineWidth', 0.9);  hold on;
plot(4*nn,real(Waveform3n), 'k', 'LineWidth', 0.9);
plot(4*n,imag(Waveform3), 'ko', 'LineWidth', 0.9);
plot(4*nn,imag(Waveform3n), 'k--', 'LineWidth', 0.9);
title('Multitone - Input Symbol:  C[2] = +1+j'); axis([0 32 -1.2 1.2]);set(gca,  'LineWidth', 1.1);
subplot(4,2,8);
plot(4*n,real(Waveform9),'ko', 'LineWidth', 0.9);  hold on;
plot(4*nn,real(Waveform9n), 'k', 'LineWidth', 0.9);
plot(4*n,imag(Waveform9), 'ko', 'LineWidth', 0.9);
plot(4*nn,imag(Waveform9n), 'k--', 'LineWidth', 0.9); 
title('Multitone - 8 Summed Symbols '); axis([0 32 -5 5]);set(gca,  'LineWidth', 1.1);

