%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 6 - Section 1: DFT / IDFT / Guard Interval Example
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 324)

N  = 8;                                             %% Sequence Length
n  = 0:1:N-1;                                       %% Time Index
C  = .707*[ 1-j; -1+j; 1+j; -1+j; 1-j; 1+j; -1-j; -1+j ]; %% Input Symbols
    
IDFT_Out = zeros(1,N);                              %% IDFT Calculation
for i = 1:N                 
    m             = i - 1;
    f             = m/N;
    AnalysisTone  = exp(j*2*pi*n*f);
    IDFT_Out      = IDFT_Out + C(i,1)*AnalysisTone;
end
GI          = IDFT_Out(1,7:8);                      %% The guard interval
OFDM_Symbol = [GI IDFT_Out];                        %% Final OFDM Symbol

DFT_Out  = zeros(1,N);                              %% DFT Calculation
for i = 1:N                 
    m             = i - 1;
    f             = m/N;
    AnalysisTone  = exp(-j*2*pi*n*f);
    DFT_Out(1,i)  = (1/N)*OFDM_Symbol(1,3:10)*AnalysisTone.';
end


DFT_Out.'

Symbols = [-1 + j; -1 - j; 1 + j]/sqrt(2);
N       = 8;
nn      = -2:.1:(N);

Waveform1n = C(1,1)*exp(j*2*pi*nn*0/N);
Waveform2n = C(2,1)*exp(j*2*pi*nn*1/N);
Waveform3n = C(3,1)*exp(j*2*pi*nn*2/N);
Waveform4n = C(4,1)*exp(j*2*pi*nn*3/N);
Waveform5n = C(5,1)*exp(-j*2*pi*nn*4/N);
Waveform6n = C(6,1)*exp(-j*2*pi*nn*3/N);
Waveform7n = C(7,1)*exp(-j*2*pi*nn*2/N);
Waveform8n = C(8,1)*exp(-j*2*pi*nn*1/N);
Waveform9n = Waveform1n + Waveform2n + Waveform3n + Waveform4n + ...
             Waveform5n + Waveform6n + Waveform7n + Waveform8n;
         
figure(1);
subplot(2,1,1);
plot(nn + 2, real(Waveform9n), 'k', 'LineWidth', 0.9); grid off; hold on;
plot(nn + 2, imag(Waveform9n), 'k--', 'LineWidth', 0.9); 
plot([-2 -1 n] + 2, real([IDFT_Out(1,7:8) IDFT_Out]), 'ko');  
plot([-2 -1 n] + 2, imag([IDFT_Out(1,7:8) IDFT_Out]), 'ko'); 
title('The Complete OFDM Symbol with Guard Interval');
legend('Real','Imag'); axis([0 10 -6 6]);set(gca, 'LineWidth', 1);

subplot(2,1,2);
stem(n, real(DFT_Out), 'k', 'LineWidth', 0.9); hold on;
stem(n, imag(DFT_Out), 'k--', 'LineWidth', 0.9);
title('Recovered Symbol from DFT Output');
axis([0 8 -1.5 1.5]); set(gca, 'LineWidth', 1);

