%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 6 - Section 2: Half-band filter OFDM
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 342)

N    = 31;                   % Number of Taps
n    = 0:N-1;
Arg  = n/2 - (N-1)/4;        % Argument inside sinc function
Hann = hann(length(n) + 2)'; % The hanning window as a row vector

%% Half Band Filter Impulse Response
h   = sinc(Arg).*(Hann(1,2:end-1) .^0.5); 

%% Computing the Frequency Response
FResolution = 0.002;
Frequencies = -0.5:FResolution:0.5;
FrequencyResponse = zeros(1,length(Frequencies));

for i = 1:length(Frequencies)                 %% The DTFT Operation
    f                      = Frequencies(1,i);
    AnalysisTone           = exp(j*2*pi*n*f);
    FrequencyResponse(1,i) = (1/N)*h*AnalysisTone';
end
LogResponse = 20*log10(abs(FrequencyResponse));

figure(1);
subplot(1,2,1)
stem(n, h, 'k'); title('Impulse Response of Halfband Filter'); xlabel('n');
axis([0 N-1 -.25 1.1])
subplot(1,2,2); 
plot(Frequencies*40e6, LogResponse - max(LogResponse), 'k'); grid on;
title('Normalized Magnitude Response of Half Band filter');
set(gca, 'XTick', 40e6*[-.5 -.25 0 .25 .5]); xlabel('Normalized Frequency');
ylabel('dB');axis([40e6*([-.5 .5]) -60 5]);