%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 6 - Section 3: Detect_FrequencyOffsets Functions
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 353)


function [FrequencyOffsets] = Detect_FrequencyOffsets(RX_Input, ...
                               FallingEdgePosition)
 
FrequencyOffsets     = zeros(1,2);     % 1- coarse and 2- fine offsets
AutoCorr_Est         = zeros(1, length(RX_Input)); 
Delay16              = zeros(1,16);
SlidingAverage1      = zeros(1,32);    % For the AutoCorr Estimate
 
%% Compute Coarse Frequency Offset
for i = 1:length(RX_Input)       
    RX_Input_16      = Delay16(1,16);  % The 16 sample delay
    Delay16(1,2:16)  = Delay16(1,1:15); 
    Delay16(1, 1)    = RX_Input(1,i);
       
    %% Compute autocorrelation estimate
    Temp                     = RX_Input(1,i)*conj(RX_Input_16);                                        
    SlidingAverage1(1,2:32)  = SlidingAverage1(1,1:31);   
    SlidingAverage1(1,1)     = Temp;                                          
    AutoCorr_Est(1,i)        = sum(SlidingAverage1)/32;    
end
Theta                 = angle(AutoCorr_Est(1, FallingEdgePosition - 50));
FrequencyOffsets(1,1) = Theta*20e6/(2*pi*16);
 
%figure(14); hold off;
%plot(real(AutoCorr_Est), 'r'); grid on; hold on;
%plot(imag(AutoCorr_Est), 'b');
%stem(FallingEdgePosition - 50, 1, 'k')
 
AutoCorr_Est_Fine    = zeros(1, length(RX_Input)); 
Delay64              = zeros(1,64);
SlidingAverage2      = zeros(1,64);    % For the AutoCorr Estimate
 
%% Compute Fine Frequency Offset
for i = 1:length(RX_Input)       
    RX_Input_64      = Delay64(1,64);   
    Delay64(1,2:64)  = Delay64(1,1:63); 
    Delay64(1, 1)    = RX_Input(1,i);
       
    %% Compute autocorrelation estimate
    Temp                     = RX_Input(1,i)*conj(RX_Input_64);                                        
    SlidingAverage2(1,2:64)  = SlidingAverage2(1,1:63);   
    SlidingAverage2(1,1)     = Temp;                                          
    AutoCorr_Est_Fine(1,i)   = sum(SlidingAverage2)/64;   
end

Theta            = angle(AutoCorr_Est_Fine(1, FallingEdgePosition +125));
FrequencyOffsets(1,2) = Theta*20e6/(2*pi*64);
 
%figure(15); hold off;
%plot(real(AutoCorr_Est_Fine), 'r'); grid on; hold on;
%plot(imag(AutoCorr_Est_Fine), 'b');
%stem(FallingEdgePosition +125, 1, 'k')
