%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 5 - Section 3: Generate Additive White Gaussian Noise function
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 277)


function Noise = Generate_AWGN(Input, SNR) 
 
MeanSquare = (1/length(Input))*(Input*Input'); 
                                       %% Total Signal Power
NoisePower = MeanSquare/(10^(SNR/10)); %% Required AC Noise Power  
STDNoise   = sqrt(NoisePower);         %% Standard Deviation of Noise 
 
Noise = STDNoise*(0.70711*randn(1,length(Input)) ...
              + j*0.70711*randn(1,length(Input)) );
