%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 6 - Section 2: Get_LongTrainingSequence Function
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 334)


function [LongTrainingSequence AllTones] = Get_LongTrainingSequence(Step)
                              %% Step = 1 (for 20MHz) or 1/2 (for 40MHz)
Positive = [0  1 -1 -1   1  1 -1  1   -1  1 -1 -1   -1 -1 -1  1 ...
            1 -1 -1  1  -1  1 -1  1    1  1  1  0    0  0  0  0];
Negative = [0  0  0  0   0  0  1  1   -1 -1  1  1   -1  1 -1  1 ...
            1  1  1  1   1 -1 -1  1    1 -1  1 -1    1  1  1  1];
AllTones = [Negative Positive];
m        = -32:31;  %% Frequency index (Actual frequency = m * 3125.KHz)

N      = 64;       %% Number of Frequency Tones
LongTrainingSymbol = zeros(1, 64/Step);
 
for n = 0:length(LongTrainingSymbol)-1   %% The IDFT Computation
    t = n*Step;
    E = exp(j*2*pi*t*m/N);
    LongTrainingSymbol(1,n+1) = AllTones*E.';   
end

if(Step == 1)
    LongTrainingSequence = [LongTrainingSymbol(1, 33:64)  ...
                            LongTrainingSymbol LongTrainingSymbol];
else
    LongTrainingSequence = [LongTrainingSymbol(1, 65:128)  ...
                            LongTrainingSymbol LongTrainingSymbol];
end