%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 6 - Section 2: Get_ShortTrainingSequence Function
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 332)

function ShortTrainingSequence = Get_ShortTrainingSequence(Step)
                           %% Step = 1 (for 20MHz) or 1/2 (for 40MHz)
 
Positive = [0 0 0 0  -1-j 0 0 0  -1-j 0 0 0   1+j 0 0 0  ...
          1+j 0 0 0   1+j 0 0 0   1+j 0 0 0     0 0 0 0];
Negative = [0 0 0 0     0 0 0 0   1+j 0 0 0  -1-j 0 0 0  ...
          1+j 0 0 0  -1-j 0 0 0  -1-j 0 0 0   1+j 0 0 0]; 
Total    = sqrt(13/6)*[Negative Positive];
m        = -32:31;
 
N                     = 64;   %% Number of Frequency Tones  
ShortTrainingSequence = zeros(1, 160/Step);
                              
for n = 0:length(ShortTrainingSequence)-1   %% The IDFT opertion
    t                            = n*Step;
    E                            = exp(j*2*pi*t*m/N);
    ShortTrainingSequence(1,n+1) = Total*E.';   
end