%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 6 - Section 2: IFFT128_GI Function
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 343)


function Payload = IFFT128_GI(Symbol_Stream)

NumberOfSymbols = floor(length(Symbol_Stream) / 48);
Payload         = zeros(1, NumberOfSymbols * 160);  
                    % 160 Samples per symbols 128 (IFFT) + 32 (GI)

IFFT64_Input      = zeros(1,64);
for i = 1:NumberOfSymbols
    Start                          = (i-1)*48 + 1; Stop = (i-1)*48 + 48;
    CurrentInput                   = Symbol_Stream(1,Start : Stop);
    IFFT64_Index                   = [1:6 8:20 22:26 38:42 44:56 58:63];
    IFFT64_Input(1,1+IFFT64_Index) = CurrentInput;%% place 48 data symbols
    IFFT64_Input(1,1+[7 21 43 57]) = [1 1 1 1];   %% place 4 pilot symbols 
    
    IFFT128_Input                  = zeros(1,128);
    IFFT128_Input(1,[1:32 97:128]) = IFFT64_Input;
    IFFT_Output                    = ifft(IFFT128_Input,128); %% The IFFT 
    Guard_Interval                 = IFFT_Output(1, 1 + (96:127));  
    
    Start                          = (i-1)*160 + 1; Stop = (i-1)*160 + 160;
    Payload(1, Start:Stop)         = 128*[Guard_Interval IFFT_Output];
end





