%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 6 - Section 2: IFFT_GI Function
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 340)

function Payload = IFFT_GI(Symbol_Stream)

NumberOfSymbols = floor(length(Symbol_Stream) / 48);
Payload         = zeros(1, NumberOfSymbols * 80);  
                    % 80 Samples per symbols 64 (IFFT) + 16 (GI)

IFFT_Input      = zeros(1,64);
for i = 1:NumberOfSymbols
    Start                        = (i-1)*48 + 1;     Stop = (i-1)*48 + 48;
    CurrentInput                 = Symbol_Stream(1,Start : Stop);
    IFFT_Index                   = [1:6 8:20 22:26 38:42 44:56 58:63];
    IFFT_Input(1,1+IFFT_Index)   = CurrentInput;  %% inserting 48 data  symbols
    IFFT_Input(1,1+[7 21 43 57]) = [1 1 1 1];     %% inserting  4 pilot symbols 
    
    IFFT_Output                  = ifft(IFFT_Input);            %% The IFFT operation
    Guard_Interval               = IFFT_Output(1, 1 + (48:63)); %% Guard Interval Def
    
    Start                        = (i-1)*80 + 1;      Stop = (i-1)*80 + 80;
    Payload(1, Start:Stop)       = 64*[Guard_Interval IFFT_Output];
end





