%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 6 - Section 3: LongSymbol_Correlator Functions
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 355)


function [LTPeak_Value1 LTPeak_Position OutputLong] = ...
        LongSymbol_Correlator(LongTrainingSymbol, ...
                              RX_Waveform, FallingEdgePosition)

L               = sign(real(LongTrainingSymbol)) + ...
                     j*sign(imag(LongTrainingSymbol));
OutputLong      = zeros(1, length(RX_Waveform));
LTPeak_Value1   = 0;
LTPeak_Position = 0;

Cross_Correlator = zeros(1,64);
for i=1:length(RX_Waveform)-64
    Output          = Cross_Correlator * fliplr(L)'; %% The Cross Correlation  
    OutputLong(1,i) = Output;                        %% Operation
               
    Cross_Correlator(1,2:64) = Cross_Correlator(1,1:63);
    Cross_Correlator(1,1)    = RX_Waveform(1,i);
    
    %% Search for first long training symbol
    if( (i > FallingEdgePosition + 54)  &&  (i < FallingEdgePosition + 54 + 64) )
        if( abs(Output) > abs(LTPeak_Value1) )
            LTPeak_Value1    = Output;
            LTPeak_Position  = i;
        end
    end
end