%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 6 - Section 2: Function for OFDM 802.11a like Transmitter
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 344)


function [Sample_Output Symbol_Stream] = OFDM_TX_802_11(...
                         NumberOf_OFDM_Symbols, BitsPerSymbol)
              %% BitsPerSymbol = 1,2,4,6 = BPSK, QPSK, 16QAM, 64QAM
            
%% 1. Compute Short and Long Training Sequences at 20MHz (Step = 1/2)
Step                  = 1;
ShortTrainingSequence = Get_ShortTrainingSequence(Step);
LongTrainingSequence  = Get_LongTrainingSequence(Step);
            
            
%% 2. Generating Random bits for Mapping Operation
rand('seed', 0);      %% Fixing the seed of the random number generator
NumberOfBits  = (48*BitsPerSymbol)*NumberOf_OFDM_Symbols;
Source_Bits   = round(rand(1,NumberOfBits)); %% Creating random input bits
Symbol_Stream = Mapper_OFDM(Source_Bits, BitsPerSymbol);

%% 3. Generating the Payload
Payload = IFFT_GI(Symbol_Stream);

%% 4. Zero-Stuffing Operation
Packet_20MHz                    = [ShortTrainingSequence ...
                                   LongTrainingSequence Payload];
Packet_Zero_Stuffed             = zeros(1,2*length(Packet_20MHz));
Packet_Zero_Stuffed(1,1:2:end)  = Packet_20MHz; 

%% 5. Computing Halfband filter coefficients
N    = 31;                   % Number of Taps
n    = 0:N-1;
Arg  = n/2 - (N-1)/4;        % Argument inside sinc function
Hann = hann(length(n) + 2)'; % The hanning window as a row vector
h    = sinc(Arg).*(Hann(1,2:end-1) .^.5); 

%% 6. The Halfband filtering operation
Sample_Output      = filter(h, 1, [Packet_Zero_Stuffed zeros(1,100)]);
 
%figure(19);
%plot(1:length(Payload), Payload, 'r'); grid on; hold on;
%plot(0.5 + (1:length(Upsampled_Payload))/2, Upsampled_Payload, 'b');

%figure(2);
%plot(0.5 + (1:length(Sample_Output))/2, Sample_Output, 'b'); grid on; hold on;
