%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 6 - Section 2: OFDM_TX_802_11_128 Function
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Undocumented Code (Uses a 128 length IFFT rather than the combination
%%                    of a 64 length IFFT and the halfband upsampling
%%                    filter)

function [Sample_Output Symbol_Stream] = OFDM_TX_802_11_128(...
                         NumberOf_OFDM_Symbols, BitsPerSymbol)
              %% BitsPerSymbol = 1,2,4,6 = BPSK, QPSK, 16QAM, 64QAM
            
%% 1. Compute Short and Long Training Sequences at 20MHz (Step = 1/2)
Step                  = .5;
ShortTrainingSequence = Get_ShortTrainingSequence(Step);
LongTrainingSequence  = Get_LongTrainingSequence(Step);
            
            
%% 2. Generating Random bits for Mapping Operation
rand('seed', 0);      %% Fixing the seed of the random number generator
NumberOfBits  = (48*BitsPerSymbol)*NumberOf_OFDM_Symbols;
Source_Bits   = round(rand(1,NumberOfBits)); %% Creating random input bits
Symbol_Stream = Mapper_OFDM(Source_Bits, BitsPerSymbol);

%% 3. Generating the Payload
Payload = IFFT128_GI(Symbol_Stream);

%% 4. Zero-Stuffing Operation
Sample_Output                    = [ShortTrainingSequence ...
                                    LongTrainingSequence Payload];