%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 6 - Section 3: Packet Detector 
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 350)

function [Comparison_Ratio PacketDetFlag FallingEdgePosition ...
          AutoCorr_Est]  = Packet_Detector(RX_Input) 
persistent             Detection_Flag;

AutoCorr_Est         = zeros(1, length(RX_Input)); 
Comparison_Ratio     = zeros(1, length(RX_Input)); 
PacketDetFlag        = zeros(1, length(RX_Input));  

Delay16              = zeros(1,16);
SlidingAverage1      = zeros(1,32);  %% For the AutoCorr Estimate
SlidingAverage2      = zeros(1,32);  %% For the Variance Estimate
Detection_Flag       = 0;  %% Short Training symbol flag

for i = 1:length(RX_Input)       
    RX_Input_16      = Delay16(1,16);   % The 16 sample delay
    Delay16(1,2:16)  = Delay16(1,1:15); 
    Delay16(1, 1)    = RX_Input(1,i);
       
    %% Compute absolute value of autocorrelation estimate
    Temp                     = RX_Input(1,i)*conj(RX_Input_16);                                        
    SlidingAverage1(1,2:32)  = SlidingAverage1(1,1:31);   
    SlidingAverage1(1,1)     = Temp;                                          
    AutoCorr_Est(1,i)        = sum(SlidingAverage1)/32;   % The sliding summation 
    AbsAutoCorr_Est          = abs(AutoCorr_Est(1,i));
    
    %% Compute Variance Estimate
    InstPower                = RX_Input(1,i)*conj(RX_Input(1,i));
    SlidingAverage2(1,2:32)  = SlidingAverage2(1,1:31);   
    SlidingAverage2(1,1)     = InstPower;     
    Variance_Est             = sum(SlidingAverage2)/32;   % The sliding summation 
                                            
    Comparison_Ratio(1,i) = AbsAutoCorr_Est/Variance_Est;
    %% PacketDetFlag with hysteresis window
    if    (Comparison_Ratio(1,i) > 0.85); Detection_Flag = 1;
    elseif(Comparison_Ratio(1,i) < 0.65); Detection_Flag = 0;
    end
    PacketDetFlag(1,i) = Detection_Flag;
    
    %% Initial timing reference by looking at deasserting PacketDetFlag
    if( (i > 1) && (i < 1000) && ...
                      (PacketDetFlag(1,i) - PacketDetFlag(1,i-1)) == -1 )
        FallingEdgePosition = i;    
    end
end